/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameCanvas;
import com.inode.pictorama.GameEngine;
import javax.microedition.lcdui.Graphics;

public class Robot {
    GameEngine ge;
    public static final int STATE_FIXED = 0;
    public static final int STATE_ANIMATE = 1;
    public static final int ANIMATE_SHOWING = 0;
    public static final int ANIMATE_HELLO = 1;
    public static final int ANIMATE_SPEAKING = 2;
    public static final int ANIMATE_THINK_1 = 3;
    public static final int ANIMATE_THINK_2 = 4;
    public static final int ANIMATE_WAITING = 5;
    public static final int ANIMATE_BYE = 6;
    public int robotState = 0;
    public int robotAnimation = 5;
    public static final int ROBOT_OFFSET_X = 35;
    public static final int ROBOT_OFFSET_Y = 60;
    public int robotXfixed = 0;
    public int robotYfixed = 0;
    public int robotX = 0;
    public int robotY = 0;
    public int robotXfinal = 0;
    public int robotYfinal = 0;
    public long robotTime = 0L;
    public int paperXfixed = 0;
    public int paperYfixed = 0;
    public int paperX = 0;
    public int paperY = 0;
    public int paperXfinal = 0;
    public int paperYfinal = 0;
    public int paperWfixed = 0;
    public int paperHfixed = 0;
    public int paperW = 0;
    public int paperH = 0;
    public int paperWfinal = 0;
    public int paperHfinal = 0;
    public String text = null;
    public int textCaret = 1;

    public Robot(GameEngine _ge) {
        this.ge = _ge;
        this.ge.auxString = "Robot()";
        this.robotTime = System.currentTimeMillis();
        this.robotX = 205;
        this.robotXfinal = 205;
        this.robotXfixed = 205;
        this.robotY = 260;
        this.robotYfinal = 260;
        this.robotYfixed = 260;
        this.paperX = 0;
        this.paperXfinal = 0;
        this.paperXfixed = 0;
        this.paperY = 260;
        this.paperYfinal = 260;
        this.paperYfixed = 260;
        this.paperW = 240;
        this.paperWfinal = 240;
        this.paperWfixed = 240;
        this.paperH = 48;
        this.paperHfinal = 48;
        this.paperHfixed = 48;
        this.text = this.ge.lang[7];
        this.hello(this.text);
    }

    public void paint(Graphics _g) {
        if (this.robotState == 1) {
            this.paintAnimate(_g);
        } else {
            this.paintFixed(_g);
        }
    }

    public void paintFixed(Graphics _g) {
        this.ge.gc.paintImageTiled(_g, this.ge.gc.resImages[21], this.paperX, this.paperY, this.paperW, this.paperH);
        GameCanvas cfr_ignored_0 = this.ge.gc;
        GameCanvas.resFonts[2].setCurrentPalette(0);
        switch (this.robotAnimation) {
            case 1: 
            case 2: {
                if (this.paperH != this.paperHfinal) break;
                this.textCaret = Math.min(this.textCaret + 1, this.text.length());
                if (this.textCaret == this.text.length()) {
                    this.robotAnimation = 5;
                }
                GameCanvas cfr_ignored_1 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.text.substring(0, this.textCaret - 1).toUpperCase().toCharArray(), this.paperX + 3, this.paperY + 5, 3 * this.paperW / 4, this.paperH, 20);
                break;
            }
            case 5: {
                GameCanvas cfr_ignored_2 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.text.toUpperCase().toCharArray(), this.paperX + 3, this.paperY + 5, 3 * this.paperW / 4, this.paperH, 20);
            }
        }
        this.ge.gc.resAnimations[0].drawAnimation(_g, this.robotAnimation, System.currentTimeMillis() - this.robotTime, this.robotX, this.robotY, true);
    }

    private void paintAnimate(Graphics _g) {
        boolean isComplete = true;
        int step = 1;
        int diffX = 0;
        int diffY = 0;
        int diffH = 0;
        int diffW = 0;
        diffY = this.paperYfinal - this.paperY;
        if (diffY != 0) {
            isComplete = false;
            step = Math.max(2, Math.abs(diffY / 4));
            if (Math.abs(diffY) < step) {
                this.paperY = this.paperYfinal;
            } else if (diffY > 0) {
                this.paperY += step;
            } else if (diffY < 0) {
                this.paperY -= step;
            }
        }
        if ((diffW = this.paperWfinal - this.paperW) != 0) {
            isComplete = false;
            step = Math.max(2, Math.abs(diffW / 4));
            if (Math.abs(diffW) < step) {
                this.paperW = this.paperWfinal;
            } else if (diffW > 0) {
                this.paperW += step;
            } else if (diffW < 0) {
                this.paperW -= step;
            }
        }
        if ((diffH = this.paperHfinal - this.paperH) != 0) {
            isComplete = false;
            step = Math.max(2, Math.abs(diffH / 4));
            if (Math.abs(diffH) < step) {
                this.paperH = this.paperHfinal;
            } else if (diffH > 0) {
                this.paperH += step;
            } else if (diffH < 0) {
                this.paperH -= step;
            }
        }
        if ((diffX = this.robotXfinal - this.robotX) != 0) {
            isComplete = false;
            step = Math.max(2, Math.abs(diffX / 10));
            if (Math.abs(diffX) < step) {
                this.robotX = this.robotXfinal;
            } else if (diffX > 0) {
                this.robotX += step;
            } else if (diffX < 0) {
                this.robotX -= step;
            }
        }
        if ((diffY = this.robotYfinal - this.robotY) != 0) {
            isComplete = false;
            step = Math.max(1, Math.abs(diffY / 10));
            if (Math.abs(diffY) < step) {
                this.robotY = this.robotXfinal;
            } else if (diffY > 0) {
                this.robotY += step;
            } else if (diffY < 0) {
                this.robotY -= step;
            }
        }
        this.paintFixed(_g);
        if (isComplete) {
            this.robotState = 0;
        }
    }

    public void speak(String _text) {
        this.text = _text;
        this.textCaret = 1;
        this.robotAnimation = 2;
        this.robotState = 1;
        this.paperXfinal = this.paperXfixed;
        this.paperYfinal = this.paperYfinal;
        this.paperWfinal = this.paperWfixed;
        this.paperHfinal = this.paperHfixed;
    }

    public void waiting() {
        this.robotAnimation = 5;
    }

    public void bye() {
        this.robotAnimation = 1;
        this.robotOut();
        this.paperOut();
    }

    public void hello(String _text) {
        this.text = _text;
        this.textCaret = 1;
        this.robotAnimation = 1;
        this.robotIn();
        this.paperIn();
    }

    public void robotIn() {
        this.robotState = 1;
        this.robotX = 240 + this.ge.gc.resAnimations[0].getWidthAnimation(2);
        this.robotXfinal = this.robotXfixed;
        this.robotYfinal = this.robotYfixed;
    }

    public void robotOut() {
        this.robotState = 1;
        this.robotX = this.robotXfixed;
        this.robotXfinal = 205 + this.ge.gc.resAnimations[0].getWidthAnimation(2);
        this.robotYfinal = this.robotYfixed;
    }

    public void robotDown() {
        this.robotState = 1;
        this.robotY = this.robotYfixed;
        this.robotYfinal = this.robotYfixed + 24;
    }

    public void robotUp() {
        this.robotState = 1;
        this.robotY = this.robotYfixed + 24;
        this.robotYfinal = this.robotYfixed;
    }

    public void paperIn() {
        this.robotState = 1;
        this.paperW = 0;
        this.paperWfinal = this.paperWfixed;
    }

    public void paperOut() {
        this.robotState = 1;
        this.paperW = this.paperWfixed;
        this.paperWfinal = 0;
    }
}

