/*
 * Decompiled with CFR 0.152.
 */
package com.inode.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SSMusic
implements PlayerListener {
    public static final int NO_SOUND = -1;
    public static final int SOUND_MIDI = 0;
    public static final int SOUND_AMR = 1;
    public static final int SOUND_MP3 = 2;
    public static final int SOUND_WAV = 3;
    public static final int MAX_ELEMENTS = 16;
    public Player[] midis = new Player[16];
    public byte[] soundType = new byte[16];
    public int lastSoundIndex;
    public int actualSound = -1;

    public SSMusic() {
        for (int i = 0; i < 16; ++i) {
            this.soundType[i] = -1;
        }
        this.lastSoundIndex = 0;
    }

    public int loadSound(byte[] soundData, int type) {
        Player p = null;
        ByteArrayInputStream is = new ByteArrayInputStream(soundData);
        if (is == null) {
            return -1;
        }
        try {
            ++this.lastSoundIndex;
            switch (type) {
                case 0: {
                    p = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                    p.realize();
                    p.prefetch();
                    this.midis[this.lastSoundIndex] = p;
                    this.soundType[this.lastSoundIndex] = 0;
                    break;
                }
                case 2: {
                    this.midis[this.lastSoundIndex] = p = Manager.createPlayer((InputStream)is, (String)"audio/mp3");
                    this.soundType[this.lastSoundIndex] = 2;
                    break;
                }
                case 1: {
                    this.midis[this.lastSoundIndex] = p = Manager.createPlayer((InputStream)is, (String)"audio/amr");
                    this.soundType[this.lastSoundIndex] = 1;
                    break;
                }
                case 3: {
                    this.midis[this.lastSoundIndex] = p = Manager.createPlayer((InputStream)is, (String)"audio/x-wav");
                    this.soundType[this.lastSoundIndex] = 3;
                }
            }
            if (p != null) {
                p.realize();
                p.prefetch();
            }
            return this.lastSoundIndex;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public boolean playSound(int soundIndex, boolean forced) {
        if (soundIndex <= this.lastSoundIndex) {
            if (forced) {
                if (this.isSound(this.actualSound)) {
                    this.stopSound(this.actualSound);
                }
            } else if (this.isSound()) {
                return false;
            }
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[soundIndex].realize();
                        this.midis[soundIndex].prefetch();
                        this.midis[soundIndex].start();
                        this.actualSound = soundIndex;
                    }
                }
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void stopSound(int soundIndex) {
        if (soundIndex <= this.lastSoundIndex && this.actualSound != -1) {
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[soundIndex].stop();
                        this.midis[soundIndex].deallocate();
                        this.actualSound = -1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isSound() {
        try {
            for (int i = 0; i < 16; ++i) {
                if (this.soundType[i] == -1 || this.midis[i].getState() != 400) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean isSound(int soundIndex) {
        try {
            return this.midis[soundIndex].getState() == 400;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void unloadSound(int soundIndex) {
        if (soundIndex <= this.lastSoundIndex) {
            --this.lastSoundIndex;
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[soundIndex].close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setVolume(int soundIndex, int percent) {
        try {
            VolumeControl vc = (VolumeControl)this.midis[soundIndex].getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(percent);
            }
        }
        catch (Exception _ex) {
            // empty catch block
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string.compareTo("endOfMedia") == 0) {
            try {
                player.stop();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.actualSound = -1;
        }
    }
}

