/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.graphics;

import com.rocktasticgames.diamonds.graphics.AssetLoader;
import com.rocktasticgames.diamonds.graphics.BackgroundElement;
import com.rocktasticgames.diamonds.parameters.Params;
import com.rocktasticgames.diamonds.utils.GraphicsContainer;
import com.rocktasticgames.diamonds.utils.XMath;

public class Particle
extends BackgroundElement {
    private float vel_x;
    private float vel_y;
    private float vel_z;
    private float angular_vel;
    private float angle;
    private int type;
    private long last_time;
    private long end_time;

    public Particle(AssetLoader assetLoader, String[] stringArray, int n, float f, float f2, long l) {
        super(assetLoader, stringArray[(int)(XMath.random() * (float)stringArray.length)], f, f2, 1, 400.0f);
        this.type = n;
        float f3 = XMath.random() - 0.5f;
        float f4 = XMath.random() - 0.5f;
        float f5 = XMath.random() - 0.5f;
        float f6 = XMath.sqrt(f3 * f3 + f4 * f4 + f5 * f5);
        this.vel_x = (f3 /= f6) * (float)Params.PARTICLE_VEL[this.type];
        this.vel_y = (f4 /= f6) * (float)Params.PARTICLE_VEL[this.type];
        this.vel_z = (f5 /= f6) * (float)Params.PARTICLE_VEL[this.type];
        this.angle = 0.0f;
        this.angular_vel = XMath.random() * (float)Params.MAX_ANGULAR_VEL[this.type] * 2.0f - (float)Params.MAX_ANGULAR_VEL[this.type];
        this.last_time = l;
        this.end_time = l + (long)Params.PARTICLE_FLY_TIME[this.type];
    }

    public boolean isDoneAnimating(long l) {
        return l > this.end_time;
    }

    public boolean render(GraphicsContainer graphicsContainer, int n, long l) {
        if (l < this.end_time - (long)Params.PARTICLE_FLY_TIME[this.type]) {
            return false;
        }
        float f = (float)(l - this.last_time) / 1000.0f;
        this.x += this.vel_x * f;
        this.y += this.vel_y * f;
        this.z += this.vel_z * f / 312.0f;
        this.angle += (3600.0f + this.angular_vel * f) % 360.0f;
        this.vel_y += 625.0f * f;
        this.vel_y /= 1.0f + (float)Params.PARTICLE_DRAG[this.type] * f / 100.0f;
        this.vel_x /= 1.0f + (float)Params.PARTICLE_DRAG[this.type] * f / 100.0f;
        this.vel_z /= 1.0f + (float)Params.PARTICLE_DRAG[this.type] * f / 100.0f;
        this.last_time = l;
        if (!this.prepare(graphicsContainer, n, 0.0f, 0.0f)) {
            return false;
        }
        if (this.z > 0.0f) {
            graphicsContainer.drawImage(this.bitmap, -this.bitmap.getWidth() / 2, -this.bitmap.getHeight() / 2, n);
        }
        graphicsContainer.restore();
        return false;
    }
}

