/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.views;

import com.rocktasticgames.diamonds.animated.AnimatedElement;
import com.rocktasticgames.diamonds.main.MainActivity;
import com.rocktasticgames.diamonds.parameters.C2MValues;
import com.rocktasticgames.diamonds.parameters.Params;
import com.rocktasticgames.diamonds.utils.GraphicsContainer;
import com.rocktasticgames.diamonds.utils.MotionEvent;
import com.rocktasticgames.diamonds.views.View;
import javax.microedition.lcdui.Image;

public class SelectionView
extends View {
    private static final int MAX_TOUCHES = 2;
    private MainActivity activity;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement title;
    private AnimatedElement back;
    private AnimatedElement background;
    private AnimatedElement[] levels;
    private boolean[] pause_tapped = new boolean[2];
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private boolean[] swipe_active = new boolean[2];
    private long swipe_time = -10000L;
    private int[] touch_ptr = new int[2];
    private boolean back_tapped = false;
    private int section;
    private long start_time;
    private boolean destroyed = false;
    private String bg_image = "bg12";
    private boolean close_page = false;
    private int level = -1;
    private int maxlevel;
    private int delays = 0;
    private int currover = 0;

    public SelectionView(MainActivity mainActivity, int n) {
        super(mainActivity);
        this.activity = mainActivity;
        this.section = n;
        this.start_time = System.currentTimeMillis();
        this.bg_image = Params.BACKGROUNDS[this.section];
        this.maxlevel = this.activity.getSharedPref().getInt("maxlevel", 0);
        this.activity.getAssetLoader().load("mapcheckmark", 1);
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        int n2 = Math.min(this.maxlevel, this.section * 10 + 9) % 10;
        if (animatedElement == null) {
            this.currover = n2;
            if (this.levels != null && this.levels[n2] != null) {
                return this.levels[n2];
            }
            return null;
        }
        if (animatedElement == this.back) {
            if (n == 1) {
                this.currover = n2;
                return this.levels[this.currover];
            }
            return this.back;
        }
        if (n == 5) {
            this.currover = Math.min(this.currover + 1, n2);
            return this.levels[this.currover];
        }
        if (n == 2) {
            this.currover = Math.max(this.currover - 1, 0);
            return this.levels[this.currover];
        }
        if (n == 1) {
            if (this.currover >= 8) {
                this.currover -= 3;
            } else if (this.currover >= 4) {
                this.currover -= 4;
            }
            return this.levels[this.currover];
        }
        if (n == 6) {
            if (this.currover < 4) {
                if (n2 >= this.currover + 4) {
                    this.currover += 4;
                    return this.levels[this.currover];
                }
                return this.back;
            }
            if (this.currover < 8 && this.currover != 4) {
                if (n2 >= this.currover + 3) {
                    this.currover += 3;
                    return this.levels[this.currover];
                }
                return this.back;
            }
            return this.back;
        }
        return animatedElement;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activity.getAssetLoader().unload("mapcheckmark");
        if (this.title != null) {
            this.title.unload();
            this.back.unload();
            this.background.unload();
            for (int i = 0; i < 10; ++i) {
                this.levels[i].unload();
            }
        }
    }

    public boolean onBack() {
        this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[this.section]);
        return false;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        this.background = new AnimatedElement(this.activity.getAssetLoader(), this.bg_image, 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.title = new AnimatedElement(this.activity.getAssetLoader(), "scorecard_wide", 0.5f, 0.09288195f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.back = new AnimatedElement(this.activity.getAssetLoader(), "button_279_back", 0.109375f, 1.2118056f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 2L);
        this.levels = new AnimatedElement[10];
        for (int i = 0; i < 10; ++i) {
            this.levels[i] = new AnimatedElement(this.activity.getAssetLoader(), "button_322_levelnumber", 0.1355f + 0.243f * (float)(i % 4 + i / 8), (455.0f + 280.0f * (float)(i / 4)) / 1152.0f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, (long)(400 - 100 * (i % 4 + i / 8)));
        }
        this.currover = Math.min(this.maxlevel, this.section * 10 + 9) % 10;
        this.activity.getCanvas().setFocus(this.levels[this.currover]);
    }

    public int getSection() {
        return this.section;
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        boolean bl = false;
        int n = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 360;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (!this.loaded && this.activity.getAssetLoader().isCurrent()) {
            this.loaded = true;
            this.start_time = System.currentTimeMillis();
        }
        this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        if (this.time < 0L) {
            this.time = 0L;
        }
        if (this.time < 302L) {
            bl = true;
        }
        graphicsContainer.save();
        graphicsContainer.scale(1.6666666f, 1.6666666f);
        this.background.render(graphicsContainer, n, this.time);
        graphicsContainer.restore();
        if (!this.loaded) {
            Image image = this.activity.getPlaceholder();
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image, 0, 0, n);
                graphicsContainer.restore();
            } else {
                graphicsContainer.setColor(-1);
                graphicsContainer.drawPaint(n);
            }
            graphicsContainer.restore();
            this.postInvalidateDelayed(50L);
            return;
        }
        if (this.back_tapped) {
            this.back.setColorFilter(Params.filter_dark);
        }
        if (!this.back.render(graphicsContainer, n, this.time)) {
            bl = true;
        }
        if (this.back_tapped) {
            this.back.setColorFilter(null);
        }
        if (this.section < 9) {
            this.activity.getTitan().setSize(this.levels[0].getHeight() * 2 / 5);
        } else {
            this.activity.getTitan().setSize(this.levels[0].getHeight() * 4 / 15);
        }
        for (int i = 0; i < this.levels.length; ++i) {
            if (this.level == i) {
                this.levels[i].setColorFilter(Params.filter_dark);
            } else if (i + this.section * 10 > this.maxlevel) {
                this.levels[i].setColorFilter(Params.filter_gray);
            }
            if (!this.levels[i].render(graphicsContainer, n, this.time)) {
                bl = true;
            }
            Image image = this.activity.getAssetLoader().get("mapcheckmark");
            if (i + this.section * 10 < this.maxlevel && image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(this.levels[i].getX(this.time), this.levels[i].getY(this.time));
                graphicsContainer.scale(1.0f, 1.0f);
                graphicsContainer.drawImage(image, -image.getWidth() / 2, -image.getHeight() * 5 / 11, n);
                graphicsContainer.restore();
            }
            this.levels[i].setColorFilter(null);
            String string = "" + (i + this.section % 4 * 10 + 1);
            graphicsContainer.save();
            graphicsContainer.translate(this.levels[i].getX(this.time) - (float)(this.activity.getTitan().measure(string) / 2), this.levels[i].getY(this.time) - this.activity.getTitan().getSize(graphicsContainer) / 2.0f);
            this.activity.getTitan().renderString(graphicsContainer, n, string);
            graphicsContainer.restore();
        }
        this.title.render(graphicsContainer, n, this.time);
        graphicsContainer.setColor(-1);
        this.activity.getCartoon().setSize(this.title.getHeight() * 2 / 5);
        String string = C2MValues.TEXT_CHOOSE_LEVEL[this.activity.getLanguage()];
        graphicsContainer.save();
        graphicsContainer.translate(this.title.getX(this.time) - (float)(this.activity.getCartoon().measure(string) / 2), this.title.getY(this.time) - this.activity.getCartoon().getSize(graphicsContainer) / 2.0f);
        this.activity.getCartoon().renderString(graphicsContainer, n, string);
        graphicsContainer.restore();
        graphicsContainer.restore();
        this.last_time = this.time;
        this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
        if (this.time < 0L) {
            this.activity.startGame(this.level);
            this.destroy();
        } else if (bl) {
            this.callInvalidate();
        } else if (this.delays == 0) {
            this.postInvalidateDelayed(50L);
        }
    }

    public void postInvalidateDelayed(long l) {
        ++this.delays;
        super.postInvalidateDelayed(l);
    }

    public void callInvalidate() {
        ++this.delays;
        this.invalidate();
    }

    public void invalidate() {
        this.delays = Math.max(0, this.delays - 1);
        super.invalidate();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized || this.close_page) {
            return false;
        }
        int n = 0;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 1: {
                this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[this.section]);
                if (this.back_tapped) {
                    this.back_tapped = false;
                    this.activity.startMap(this.section / 7);
                } else if (this.level != -1) {
                    this.activity.startPregame(this.level + this.section * 10);
                }
                this.swipe_active[n] = false;
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                this.swipe_active[n] = false;
                if (this.back.isLoaded() && this.back.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.back_tapped = true;
                    this.activity.playSound("standard_click");
                } else {
                    for (int i = 0; i < this.levels.length && i + this.section * 10 <= this.maxlevel; ++i) {
                        if (!this.levels[i].inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) continue;
                        this.level = i;
                        this.activity.getMusic().playEffect("standard_click");
                        return true;
                    }
                    this.swipe_time = this.last_time;
                    this.swipe_active[n] = true;
                    this.mousex[n] = f;
                    this.mousey[n] = f2;
                }
                return true;
            }
            case 3: {
                if (this.back_tapped && !this.back.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.back_tapped = false;
                } else if (this.level != -1 && !this.levels[this.level].inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.level = -1;
                } else if (this.swipe_active[n]) {
                    // empty if block
                }
                return true;
            }
        }
        return true;
    }
}

