/*
 * Decompiled with CFR 0.152.
 */
public class ColorUtils {
    public static final int blend(int c1, int c2, int value256) {
        int v1 = value256 & 0xFF;
        int v2 = 255 - v1;
        int c1_RB = c1 & 0xFF00FF;
        int c2_RB = c2 & 0xFF00FF;
        int c1_AG = c1 >>> 8 & 0xFF00FF;
        int c2_AG = c2 >>> 8 & 0xFF00FF;
        return c1_RB * v1 + c2_RB * v2 >> 8 & 0xFF00FF | c1_AG * v1 + c2_AG * v2 & 0xFF00FF00;
    }

    public static int darker(int c) {
        int a = c >> 24 & 0xFF;
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c >> 0 & 0xFF;
        r = r * 15 >> 4;
        g = g * 15 >> 4;
        b = b * 15 >> 4;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int lighter(int c) {
        int a = c >> 24 & 0xFF;
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c >> 0 & 0xFF;
        r = Math.max(1, Math.min(255, r * 17 >> 4));
        g = Math.max(1, Math.min(255, g * 17 >> 4));
        b = Math.max(1, Math.min(255, b * 17 >> 4));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int mix(int c1, int c2) {
        int c_RB = (c1 & 0xFF00FF) + (c2 & 0xFF00FF) >> 1 & 0xFF00FF;
        int c_AG = ((c1 & 0xFF00FF00) >>> 1) + ((c2 & 0xFF00FF00) >>> 1) & 0xFF00FF00;
        return c_RB | c_AG;
    }

    public static int mix(int c1, int c2, int c3, int c4) {
        int c_RB = (c1 & 0xFF00FF) + (c2 & 0xFF00FF) + (c3 & 0xFF00FF) + (c4 & 0xFF00FF) >> 2 & 0xFF00FF;
        int c_AG = ((c1 & 0xFF00FF00) >>> 2) + ((c2 & 0xFF00FF00) >>> 2) + ((c3 & 0xFF00FF00) >>> 2) + ((c4 & 0xFF00FF00) >>> 2) & 0xFF00FF00;
        return c_RB | c_AG;
    }
}

