/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Client;

import athan.src.Client.MainForm;
import athan.src.Client.OptionForm;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.Factory.ThreadTimer;
import com.sun.lwuit.Command;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.impl.midp.VKBImplementationFactory;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.Resources;
import java.util.Date;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public class Main
extends MIDlet
implements ActionListener {
    private static final int OPTIONS_COMMAND = 1;
    public static final Command optionsCommand = new Command("", 1);
    private static final int EXIT_COMMAND = 2;
    public static final Command exitCommand = new Command("", 2);
    private static final int MINIMIZE_COMMAND = 3;
    public static final Command minimizeCommand = new Command("", 3);
    private static final int WEBSITE_COMMAND = 4;
    public static final Command websiteCommand = new Command("", 4);
    public static Resources theme;
    public static Resources icons;
    public static Resources languages;
    public static boolean sIsTactile;
    private static OptionForm sOptionForm;
    private static MainForm sMainForm;
    private static Thread sTimer;
    private static String midletVersion;

    public static OptionForm getOptionForm() {
        return sOptionForm;
    }

    public static void setOptionForm(OptionForm pOptionForm) {
        sOptionForm = pOptionForm;
    }

    public static MainForm getMainForm() {
        return sMainForm;
    }

    public static void setMainForm(MainForm pMainForm) {
        sMainForm = pMainForm;
    }

    public static boolean isTactile() {
        return sIsTactile;
    }

    public static String getMidletVersion() {
        return midletVersion;
    }

    protected void startApp() {
        try {
            if (sMainForm == null) {
                midletVersion = this.getAppProperty("MIDlet-Version");
                if (midletVersion == null) {
                    midletVersion = "";
                }
                VKBImplementationFactory.init();
                com.sun.lwuit.Display.init(this);
                sIsTactile = com.sun.lwuit.Display.getInstance().isTouchScreenDevice();
                if (sIsTactile) {
                    UIManager.getInstance().getLookAndFeel().setTouchMenus(true);
                    UIManager.getInstance().getLookAndFeel().setTactileTouchDuration(100);
                    System.out.println("TELEPHONE TACTILE");
                } else {
                    System.out.println("TELEPHONE NON TACTILE");
                }
                theme = Resources.open("/theme.res");
                UIManager.getInstance().setThemeProps(theme.getTheme(theme.getThemeResourceNames()[0]));
                icons = Resources.open("/icons.res");
                languages = Resources.open("/languages.res");
                ServiceFactory.newInstance();
                ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();
                optionsCommand.setCommandName(RESSOURCE.get("Command.Options"));
                exitCommand.setCommandName(RESSOURCE.get("Command.Exit"));
                minimizeCommand.setCommandName("Command.Minimize");
                websiteCommand.setCommandName("Command.Website");
                com.sun.lwuit.Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        Main.this.setMainForm(icons);
                    }
                });
            }
        }
        catch (Throwable ex) {
            this.quitter();
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean arg0) {
        Main.arreterTimer();
    }

    void setMainForm(Resources r) {
        MainForm.setOptionForm(false);
        sMainForm = new MainForm(this);
        sMainForm.run(exitCommand, this, false);
        ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
        Main.demarrerTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arreterTimer() {
        MainForm mainForm = sMainForm;
        synchronized (mainForm) {
            sMainForm.setTimerHeureCourante(false);
            if (sTimer != null) {
                try {
                    sTimer.join();
                    sTimer = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (sMainForm != null) {
            sMainForm.montrerCmdHeureCourante();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void demarrerTimer() {
        MainForm mainForm = sMainForm;
        synchronized (mainForm) {
            sMainForm.setTimerHeureCourante(true);
            if (sTimer == null) {
                sTimer = new ThreadTimer();
            }
        }
        if (!sTimer.isAlive()) {
            sTimer.start();
        }
        if (sMainForm != null) {
            sMainForm.cacherCmdHeureCourante();
        }
    }

    public void actionPerformed(ActionEvent pActionEvent) {
        Command cmd = pActionEvent.getCommand();
        switch (cmd.getId()) {
            case 1: {
                if (Main.getMainForm() == null) break;
                Main.arreterTimer();
                MainForm.setOptionForm(true);
                break;
            }
            case 3: {
                Main.demarrerTimer();
                boolean retour = com.sun.lwuit.Display.getInstance().minimizeApplication();
                if (retour) break;
                Display.getDisplay((MIDlet)this).setCurrent(null);
                break;
            }
            case 2: {
                this.quitter();
                break;
            }
            case 4: {
                try {
                    this.platformRequest(ServiceFactory.getFactory().getResourceReader().get("WebsiteUrl"));
                }
                catch (Exception exc) {}
                break;
            }
        }
    }

    private void quitter() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }
}

