/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Avatar;
import game.CustomFonts;
import game.Game;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;

public class Clock {
    private static int sMsgColor = 0xFF2323;
    private static long sStartTimeMessage;
    private static int sClockImageId;
    private static int sClockHandLength;
    private static int sCentreClockX;
    private static int sCentreClockY;
    private static int sClockPosX;
    private static int sClockPosY;
    private static boolean sNeedMessage;
    private static boolean sShakingClock;
    private static int sClockHandStartX;
    private static int sClockHandStartY;
    private static int sClockHandEndX;
    private static int sClockHandEndY;
    private static int sPosYMessage;
    private static int sFontHeight;

    public static final void init() {
        sClockImageId = Game.sGameStyle == 0 ? 32 : 46;
        sClockHandLength = RM.getValue(74, Game.sGameStyle, 0);
        sCentreClockX = RM.getValue(74, Game.sGameStyle, 1);
        sCentreClockY = RM.getValue(74, Game.sGameStyle, 2);
        sClockPosX = RM.getValue(74, Game.sGameStyle, 3);
        sClockPosY = RM.getValue(74, Game.sGameStyle, 4);
    }

    public static final void restart() {
        sShakingClock = false;
        sNeedMessage = false;
    }

    private static final void rotateClockHandle(int n) {
        int n2 = RM.getLength(76);
        int n3 = (int)(Game.sAllFrameTime / 100L);
        int n4 = RM.getInts(76)[n3 % n2];
        int n5 = RM.getInts(76)[(n3 + n2 / 4) % n2];
        int n6 = sClockHandLength * n4;
        int n7 = -sClockHandLength * n5;
        sClockHandStartX = sCentreClockX + sClockPosX + n;
        sClockHandStartY = sCentreClockY + sClockPosY + n;
        sClockHandEndX = sCentreClockX + sClockPosX + n + (n6 >> 10);
        sClockHandEndY = sCentreClockY + sClockPosY + n + (n7 >> 10);
    }

    private static final void drawClockHand() {
        Graphics graphics = GCanvas.getTargetGraphics();
        graphics.setColor(0xFF0000);
        graphics.drawLine(sClockHandStartX, sClockHandStartY, sClockHandEndX, sClockHandEndY);
        graphics.drawLine(sClockHandStartX + 1, sClockHandStartY, sClockHandEndX + 1, sClockHandEndY);
        graphics.drawLine(sClockHandStartX, sClockHandStartY + 1, sClockHandEndX, sClockHandEndY + 1);
    }

    public static final void updateTextSlide() {
        if (sNeedMessage) {
            sPosYMessage -= 6;
        }
    }

    public static final void displayMessage() {
        sNeedMessage = true;
        sStartTimeMessage = System.currentTimeMillis();
        sShakingClock = true;
        sPosYMessage = GCanvas.getGameHeight() + 1;
    }

    public static final void drawMessage() {
        if (sNeedMessage) {
            int n = CustomFonts.getStringWidth(RM.t(98));
            sFontHeight = CustomFonts.getFontHeight();
            int n2 = sPosYMessage;
            CustomFonts.drawString(GCanvas.getTargetGraphics(), RM.t(98), GCanvas.getGameWidth() - n >> 1, n2 - CustomFonts.getFontHeight());
            n = CustomFonts.getStringWidth(RM.t(99));
            CustomFonts.drawString(GCanvas.getTargetGraphics(), RM.t(99), GCanvas.getGameWidth() - n >> 1, n2);
        }
    }

    public static final void update() {
        Clock.updateTextSlide();
    }

    public static final void drawClock(boolean bl) {
        int n = 0;
        if (sShakingClock) {
            n = Math.abs(Game.random.nextInt() % 3) - 1;
        }
        GCanvas.drawImage(sClockImageId, sClockPosX + n, sClockPosY + n, 0);
        if (!Game.sPauseReplay && bl) {
            Clock.rotateClockHandle(n);
        }
        Clock.drawClockHand();
        if (sNeedMessage && sPosYMessage < -sFontHeight) {
            sNeedMessage = false;
            sShakingClock = false;
        }
    }

    public static final void draw() {
        if (Game.sStartTimeIsSet) {
            Clock.drawClock(true);
        } else if (Avatar.getPosY() > GCanvas.getGameHeight() - Avatar.sAvatarHeight) {
            Clock.drawClock(false);
        } else {
            GCanvas.drawImage(sClockImageId, sClockPosX, sClockPosY, 0);
            GCanvas.getTargetGraphics().setColor(0xFF0000);
            GCanvas.getTargetGraphics().drawLine(sCentreClockX + sClockPosX, sCentreClockY + sClockPosY, sCentreClockX + sClockPosX, sCentreClockY + sClockPosY - sClockHandLength);
            GCanvas.getTargetGraphics().drawLine(sCentreClockX + 1 + sClockPosX, sCentreClockY + sClockPosY, sCentreClockX + 1 + sClockPosX, sCentreClockY + sClockPosY - sClockHandLength);
        }
    }
}

