/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.GameBoard;
import game.RandomGenerator;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;

public class Floor {
    private static int sFontWidth = RM.getValue(73, 0, 0);
    private static int sFontHeight = RM.getValue(73, 0, 1);
    private static int sFontImageId = 23;
    private byte mFloorType;
    private int mFloorSpriteId;
    private int mFloorXPos;
    private int mFloorWidth;
    private byte mFloorWidthId;
    private int mFloorIndex;
    private int mFloorSpriteWidth;
    private int mFloorSpriteHeight;

    public Floor(int n, int n2, int n3) {
        this.reinitFloor(n, n2, n3);
    }

    public void reinitFloor(int n, int n2, int n3) {
        this.mFloorIndex = n3;
        this.mFloorWidthId = (byte)n;
        this.mFloorSpriteId = RM.getValue(63, Game.sGameStyle, 0);
        this.mFloorSpriteWidth = GCanvas.getSpriteWidth(this.mFloorSpriteId);
        this.mFloorSpriteHeight = GCanvas.getSpriteHeight(this.mFloorSpriteId);
        this.mFloorType = (byte)n2;
        this.mFloorWidth = this.calculateFloorWidth(n);
        this.mFloorXPos = this.randomXPos(n);
    }

    public void reCalcXPosition(Floor floor, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = Game.calcPercentage(this.mFloorWidth, 100 - n);
        int n6 = Math.abs(this.mFloorWidth - floor.getFloorWidth());
        if (this.mFloorWidth <= floor.getFloorWidth()) {
            n4 = floor.getXPos() - n5;
            n3 = floor.getXPos() + n6 + n5;
        } else {
            n4 = floor.getXPos() - n6 - n5;
            n3 = floor.getXPos() + n5;
        }
        if (n4 < GameBoard.getWallWidth()) {
            n4 = GameBoard.getWallWidth();
        }
        if (n3 + this.mFloorWidth > GCanvas.getGameWidth() - GameBoard.getWallWidth()) {
            n3 = GCanvas.getGameWidth() - GameBoard.getWallWidth() - this.mFloorWidth;
        }
        this.mFloorXPos = (n2 = Math.abs(n3 - n4)) != 0 ? n4 + RandomGenerator.nextInt() % n2 : n4;
    }

    public int getFloorIndex() {
        return this.mFloorIndex;
    }

    public int calculateFloorWidth(int n) {
        int n2 = this.mFloorSpriteWidth / 3;
        return (2 + RM.getValue(70, n)) * n2;
    }

    private int randomXPos(int n) {
        if (n == 3) {
            return GCanvas.getGameWidth() - this.mFloorWidth >> 1;
        }
        return RandomGenerator.nextInt() % (GCanvas.getGameWidth() - (GameBoard.getWallWidth() << 1) - this.mFloorWidth) + GameBoard.getWallWidth();
    }

    public int getXPos() {
        return this.mFloorXPos;
    }

    public int getFloorWidth() {
        return this.mFloorWidth;
    }

    public void drawSign(Graphics graphics, int n, int n2) {
        int n3 = Game.sGameStyle == 0 ? 6 : 7;
        int n4 = GCanvas.getSpriteWidth(n3);
        int n5 = this.mFloorXPos + (this.mFloorWidth - n4 >> 1);
        int n6 = n2 + (this.mFloorSpriteHeight >> 1);
        int n7 = 0;
        if (this.mFloorType != 4 || Game.sGameStyle == 1) {
            // empty if block
        }
        GCanvas.drawSprite(graphics, n3, n5, n6 - 4 + n7 + 0, this.mFloorType);
        String string = "" + n;
        int n8 = n5 + (n4 - string.length() * sFontWidth >> 1);
        int n9 = n6 + (GCanvas.getSpriteHeight(n3) - sFontHeight >> 1);
        if (Game.sGameStyle == 0) {
            if (this.mFloorType >= 2) {
                ++n9;
            }
        } else if (this.mFloorType == 2) {
            ++n9;
        }
        this.drawOwnFontNumbers(graphics, string, n8, n9 - 4 + n7 + 0);
    }

    private void drawElement(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GCanvas.pushClip(graphics);
        graphics.clipRect(n4, n5, n3, this.mFloorSpriteHeight);
        GCanvas.drawSprite(graphics, this.mFloorSpriteId, n4 - n2, n5, this.mFloorType);
        GCanvas.popClip(graphics);
    }

    public void draw(Graphics graphics, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = RM.getValue(70, this.mFloorWidthId);
        int n5 = this.mFloorSpriteWidth / 3;
        this.drawElement(graphics, this.mFloorType, n3, n5, this.mFloorXPos, n);
        n2 += n5;
        n3 += n5;
        for (int i = 0; i < n4; ++i) {
            this.drawElement(graphics, this.mFloorType, n3, n5, this.mFloorXPos + n2, n);
            n2 += n5;
        }
        this.drawElement(graphics, this.mFloorType, n3 += n5, n5, this.mFloorXPos + n2, n);
        if (this.mFloorIndex != 0 && this.mFloorIndex % 10 == 0) {
            this.drawSign(graphics, this.mFloorIndex, n);
        }
    }

    private void drawOwnFont(Graphics graphics, int n, int n2, int n3) {
        GCanvas.pushClip(graphics);
        graphics.clipRect(n2, n3, sFontWidth, sFontHeight + 2);
        graphics.drawImage(RM.getImage(sFontImageId), n2 - n * sFontWidth, n3, 20);
        GCanvas.popClip(graphics);
    }

    public void drawOwnFontNumbers(Graphics graphics, String string, int n, int n2) {
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            int n4 = string.charAt(i) - 48;
            this.drawOwnFont(graphics, n4, n + sFontWidth * i, n2 - 1);
        }
    }
}

