/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Avatar;
import game.Clock;
import game.Combo;
import game.Floor;
import game.Game;
import game.RandomGenerator;
import game.Replay;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tinbrain.GCanvas;
import tinbrain.RM;

public class GameBoard {
    private static int sNoOfGeneratedFloors;
    public static int sFloorsGap;
    public static int sYStartPosition;
    public static int sFloorsHeight;
    private static int sFloorsStyle;
    private static int sScore;
    private static int sScoreFromCombos;
    private static int sOverallScore;
    private static int sWhenChangingStyle;
    private static int sWhenDrawingLongFloor;
    public static int sScrollSpeed;
    private static boolean sMaxSpeed;
    public static int sStartingFloorStyle;
    public static int[] sMaxFloor;
    private static int sTileSize;
    private static Image sBackBuffer;
    private static Graphics sBackBufferGraphics;
    private static int sWallPosOffset;
    private static int sBackdropPosOffset;
    private static int sTilePosOffset;
    private static Floor[] sItemsArray;
    private static int sStartItemsIdx;
    private static Image sWallLeftImage;
    private static Image sWallRightImage;
    private static Image sBackdropImage;
    private static int sWallWidth;
    private static int sBackdropWidth;
    private static Floor sPrevFloor;
    private static byte[] sFloorWidthIdLimits;
    private static int sGraduationNumber;
    private static int sGraduationOverlappingNumber;

    public static final void init() {
        sFloorsHeight = GCanvas.getSpriteHeight(RM.getValue(63, Game.sGameStyle, 0));
        sFloorsGap = RM.getValue(68, Game.sGameStyle, 0);
        sYStartPosition = Game.sScreenHeight - sFloorsHeight;
        sWhenChangingStyle = RM.getValue(68, Game.sGameStyle, 3);
        sWhenDrawingLongFloor = RM.getValue(68, Game.sGameStyle, 4);
        sTileSize = 72;
        if (Game.sGameStyle == 0) {
            sWallLeftImage = RM.getImage(42);
            sWallWidth = sWallLeftImage.getWidth();
            sWallRightImage = RM.getImage(43);
            sBackdropImage = RM.getImage(44);
            sBackdropWidth = sBackdropImage.getWidth();
        } else {
            sWallLeftImage = RM.getImage(54);
            sWallWidth = sWallLeftImage.getWidth();
            sWallRightImage = RM.getImage(55);
            sBackdropImage = RM.getImage(56);
            sBackdropWidth = sBackdropImage.getWidth();
        }
        if (sBackBuffer == null) {
            GameBoard.initBackBuffer(GCanvas.getGameWidth(), 72 * (GCanvas.getGameHeight() / 72 + 2));
        }
    }

    public static final void initBackBuffer(int n, int n2) {
        sBackBuffer = Image.createImage((int)n, (int)n2);
        sBackBufferGraphics = sBackBuffer.getGraphics();
        sItemsArray = new Floor[sBackBuffer.getHeight() / 72];
    }

    public static final void restart() {
        sYStartPosition = Game.sScreenHeight - sFloorsHeight;
        sMaxSpeed = false;
        sFloorsStyle = sStartingFloorStyle;
        sScore = 0;
        sScrollSpeed = 0;
        sScoreFromCombos = 0;
        sNoOfGeneratedFloors = 0;
        sOverallScore = 0;
        GameBoard.initFloorWidthLimits();
        sStartItemsIdx = sItemsArray.length - 1;
        sTilePosOffset = 0;
        sWallPosOffset = 0;
        sBackdropPosOffset = 0;
        for (int i = sItemsArray.length - 1; i >= 0; --i) {
            Floor floor;
            GameBoard.sItemsArray[GameBoard.sStartItemsIdx] = floor = GameBoard.addFloor(sStartItemsIdx, sItemsArray[sStartItemsIdx]);
            if (--sStartItemsIdx >= 0) continue;
            sStartItemsIdx += sItemsArray.length;
        }
    }

    public static final int getWallWidth() {
        return sWallWidth;
    }

    public static final int getFloorsHeight() {
        return sFloorsHeight;
    }

    public static final int getFirstFloorYPos() {
        return sYStartPosition;
    }

    public static final int getFloorsGap() {
        return sFloorsGap;
    }

    private static final Floor generateFloor(int n, int n2, Floor floor) {
        int n3;
        boolean bl = true;
        if (n % sWhenDrawingLongFloor == 0 || n == 0) {
            n3 = 3;
            bl = false;
        } else {
            n3 = GameBoard.randomFloorsWidth();
            n3 = GameBoard.checkFloorWidthLimits(n3, n);
        }
        int n4 = GCanvas.getSpriteFrames(RM.getValue(63, Game.sGameStyle, 0));
        if (n2 < n4) {
            if (floor == null) {
                floor = new Floor(n3, n2, n);
            } else {
                floor.reinitFloor(n3, n2, n);
            }
        } else if (floor == null) {
            floor = new Floor(n3, n4 - 1, n);
        } else {
            floor.reinitFloor(n3, n4 - 1, n);
        }
        if (bl) {
            GameBoard.checkPlatformOverlapping(floor, n);
        }
        return floor;
    }

    private static final void initFloorWidthLimits() {
        GameBoard.sFloorWidthIdLimits[0] = 0;
        GameBoard.sFloorWidthIdLimits[1] = 0;
        sGraduationNumber = 0;
        sPrevFloor = null;
        sGraduationOverlappingNumber = 0;
    }

    private static final int checkFloorWidthLimits(int n, int n2) {
        int n3;
        if (n > 1 || Game.sGameDifficulty == Game.DIFFICULTY_HARD) {
            return n;
        }
        int n4 = RM.getHeight(71);
        boolean bl = false;
        for (n3 = sGraduationNumber; n3 < n4; ++n3) {
            int n5 = RM.getValue(71, n3, 2);
            if (n2 > n5) continue;
            bl = true;
            if (sGraduationNumber == n3) break;
            sGraduationNumber = n3;
            GameBoard.sFloorWidthIdLimits[0] = 0;
            GameBoard.sFloorWidthIdLimits[1] = 0;
            break;
        }
        if (!bl) {
            return n;
        }
        n3 = RM.getValue(71, sGraduationNumber, n);
        if (n3 == -1) {
            return n;
        }
        if (sFloorWidthIdLimits[n] + 1 <= n3) {
            int n6 = n;
            sFloorWidthIdLimits[n6] = (byte)(sFloorWidthIdLimits[n6] + 1);
        } else if (n == 0 && sFloorWidthIdLimits[n + 1] + 1 <= RM.getValue(71, sGraduationNumber, n + 1)) {
            int n7 = n + 1;
            sFloorWidthIdLimits[n7] = (byte)(sFloorWidthIdLimits[n7] + 1);
            ++n;
        } else {
            n = 2;
        }
        return n;
    }

    private static final void checkPlatformOverlapping(Floor floor, int n) {
        int n2;
        if (Game.sGameDifficulty == Game.DIFFICULTY_HARD) {
            return;
        }
        int n3 = RM.getHeight(72);
        boolean bl = false;
        for (n2 = sGraduationOverlappingNumber; n2 < n3; ++n2) {
            int n4 = RM.getValue(72, n2, 1);
            if (n > n4) continue;
            bl = true;
            if (sGraduationOverlappingNumber == n2) break;
            sGraduationOverlappingNumber = n2;
            break;
        }
        if (!bl) {
            return;
        }
        if (sPrevFloor != null) {
            n2 = RM.getValue(72, sGraduationOverlappingNumber, 0);
            floor.reCalcXPosition(sPrevFloor, n2);
        }
        sPrevFloor = floor;
    }

    private static final int randomFloorsWidth() {
        return RandomGenerator.nextInt() % RM.getValue(68, Game.sGameStyle, 8);
    }

    public static final int setScrollSpeed(long l, boolean bl) {
        int n;
        if (!sMaxSpeed) {
            long l2 = Game.sAllFrameTime;
            if (!Game.sModeReplay) {
                if (l2 > (long)(RM.getValue(67, Game.sGameDifficulty, sScrollSpeed) * 1000)) {
                    if (sScrollSpeed < 7) {
                        if (sScrollSpeed > 0) {
                            Clock.displayMessage();
                        }
                        Replay.sChangeScrollFrames[Replay.sChangeScrollIndex] = Game.frameCount;
                        ++Replay.sChangeScrollIndex;
                        ++sScrollSpeed;
                    } else {
                        sMaxSpeed = true;
                    }
                }
            } else if (Game.frameCount == Replay.sChangeScrollFrames[Replay.sChangeScrollIndex]) {
                if (sScrollSpeed < 7) {
                    if (sScrollSpeed > 0) {
                        Clock.displayMessage();
                    }
                    ++Replay.sChangeScrollIndex;
                    ++sScrollSpeed;
                } else {
                    sMaxSpeed = true;
                }
            }
        }
        if (bl) {
            if (Avatar.getPosY() < 0) {
                if (Avatar.sJumpSpeed > 0) {
                    return Math.max(Avatar.sJumpSpeed, 7);
                }
                return 6;
            }
            if (Avatar.getPosY() < 20) {
                if (Avatar.sJumpSpeed > 0) {
                    return Math.min(Avatar.sJumpSpeed, 5);
                }
                return 5;
            }
            if (Avatar.getPosY() < GCanvas.getGameHeight() / 4) {
                if (Avatar.sJumpSpeed > 0) {
                    return Math.min(Avatar.sJumpSpeed, 4);
                }
                return 4;
            }
        }
        if ((n = RM.getValue(66, sScrollSpeed) + Game.sCheatScrollSpeed) > 0) {
            return n;
        }
        return 0;
    }

    public static final void update(long l, boolean bl) {
        int n = GameBoard.setScrollSpeed(l, bl);
        sYStartPosition += n;
        if (sTilePosOffset < sTileSize && sTilePosOffset + n >= sTileSize) {
            Floor floor;
            sTilePosOffset += n;
            sTilePosOffset %= sTileSize;
            GameBoard.sItemsArray[GameBoard.sStartItemsIdx] = floor = GameBoard.addFloor(sStartItemsIdx, sItemsArray[sStartItemsIdx]);
            if (--sStartItemsIdx < 0) {
                sStartItemsIdx += sItemsArray.length;
            }
        } else {
            sTilePosOffset += n;
        }
    }

    private static final Floor addFloor(int n, Floor floor) {
        floor = GameBoard.generateFloor(sNoOfGeneratedFloors, sFloorsStyle, floor);
        if (++sNoOfGeneratedFloors % sWhenChangingStyle == 0) {
            ++sFloorsStyle;
        }
        int n2 = n * sTileSize;
        sBackBufferGraphics.drawImage(sBackdropImage, sWallWidth, n2, 0);
        floor.draw(sBackBufferGraphics, n2 + sFloorsGap - sFloorsHeight);
        sBackBufferGraphics.drawImage(sWallLeftImage, 0, n2, 0);
        sBackBufferGraphics.drawImage(sWallRightImage, sWallWidth + sBackdropWidth, n2, 0);
        return floor;
    }

    private static final void drawCircularBuffer(Graphics graphics) {
        int n = sBackBuffer.getHeight() - GCanvas.getGameHeight();
        int n2 = (sItemsArray.length - (sStartItemsIdx + 1)) * sTileSize;
        int n3 = sItemsArray.length - (sItemsArray.length - (sStartItemsIdx + 1));
        GCanvas.pushClip(graphics);
        int n4 = sFloorsHeight;
        int n5 = GCanvas.getGameHeight() - n3 * sTileSize + n4;
        int n6 = n3 * sTileSize;
        if (n6 + n5 > GCanvas.getGameHeight()) {
            n6 = GCanvas.getGameHeight() - n5;
        }
        if (n6 > 0) {
            GCanvas.setClip(graphics, 0, n5, sBackBuffer.getWidth(), n6);
            graphics.drawImage(sBackBuffer, 0, sTilePosOffset - n + n2 + n4, 0);
        }
        if (n2 != 0) {
            int n7 = sItemsArray.length - n3;
            int n8 = (sItemsArray.length - n7) * sTileSize;
            GCanvas.setClip(graphics, 0, 0, sBackBuffer.getWidth(), GCanvas.getGameHeight());
            graphics.drawImage(sBackBuffer, 0, sTilePosOffset - n - n8 + n4, 0);
        }
        GCanvas.popClip(graphics);
    }

    public static final void addComboScore(int n) {
        if (Combo.sAddScoreFromCombo) {
            sScoreFromCombos += n;
            Combo.sAddScoreFromCombo = false;
        }
    }

    public static final void calculateScore(int n) {
        if (!Avatar.isFalling() && !Avatar.isJumping()) {
            sScore = n * 10;
            Game.sMaxFloors = n;
        }
        sOverallScore = sScore + sScoreFromCombos;
    }

    public static final int getScore() {
        return sOverallScore;
    }

    public static final Floor getFloor(int n) {
        for (int i = sItemsArray.length - 1; i >= 0; --i) {
            int n2 = sItemsArray[i].getFloorIndex();
            if (n2 != n) continue;
            return sItemsArray[i];
        }
        return null;
    }

    public static final int getCurrentFloor(int n) {
        int n2 = -1;
        int n3 = sStartItemsIdx;
        int n4 = sItemsArray.length - 1;
        while (n4 >= 0) {
            int n5;
            int n6;
            int n7 = n3;
            if (n7 < 0) {
                n7 += sItemsArray.length;
            }
            if ((n6 = sYStartPosition - (n5 = sItemsArray[n7].getFloorIndex()) * sTileSize) < n + (Game.sScreenHeight - GCanvas.getGameHeight()) + Avatar.sAvatarHeight) break;
            n2 = n5;
            --n4;
            --n3;
        }
        return n2;
    }

    public static final void drawScore(Graphics graphics) {
        graphics.setColor(-16777216);
        Font font = Game.getFont(1);
        graphics.fillRect(0, 0, GCanvas.getGameWidth(), font.getHeight() + 2);
        graphics.setColor(-1);
        graphics.setFont(font);
        String string = RM.t(87);
        graphics.drawString(string + " " + sOverallScore, 1, 2, 0);
    }

    public static final void draw(Graphics graphics) {
        GameBoard.drawCircularBuffer(graphics);
    }

    static {
        sMaxFloor = new int[2];
        sPrevFloor = null;
        sFloorWidthIdLimits = new byte[2];
    }
}

