/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Avatar;
import game.Game;
import game.GameBoard;
import game.Keys;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import tinbrain.Menu;
import tinbrain.RM;

public class Replay {
    public static boolean sLoadError = false;
    public static String sStringError;
    public static int[] sChangeScrollFrames;
    public static int sChangeScrollIndex;
    public static Vector sKeyPressedVector;
    public static Vector sKeyReleasedVector;
    private static int sKeyPressedFrame;
    private static int sKeyReleasedFrame;
    public static int sKeyPressedArrayIndex;
    public static int sKeyReleasedArrayIndex;
    public static int sKeyPressedIndex;
    public static int sKeyReleasedIndex;
    public static int sRandomSeed;
    private static int sNumPressedMoves;
    private static int sNumReleasedMoves;

    public static void addKeyPressedArray() {
        sKeyPressedVector.addElement(new int[512][3]);
    }

    public static void addKeyReleasedArray() {
        sKeyReleasedVector.addElement(new int[512][3]);
    }

    public static void initVector() {
        if (sChangeScrollFrames == null) {
            sChangeScrollFrames = new int[8];
        }
        sKeyPressedVector.removeAllElements();
        sKeyReleasedVector.removeAllElements();
        sKeyPressedVector.addElement(new int[512][3]);
        sKeyReleasedVector.addElement(new int[512][3]);
        Replay.cleanVariables();
    }

    private static int[][] getArray(Vector vector) {
        if (vector == sKeyPressedVector) {
            return (int[][])vector.elementAt(sKeyPressedArrayIndex);
        }
        return (int[][])vector.elementAt(sKeyReleasedArrayIndex);
    }

    public static final void restart() {
        sLoadError = false;
        Replay.initVector();
        Replay.cleanArray(Replay.getArray(sKeyPressedVector));
        Replay.cleanArray(Replay.getArray(sKeyReleasedVector));
        Replay.cleanVariables();
    }

    public static final void initPlayback() {
        Replay.cleanVariables();
    }

    private static final void cleanVariables() {
        sKeyPressedFrame = 0;
        sKeyReleasedFrame = 0;
        sKeyPressedIndex = 0;
        sKeyReleasedIndex = 0;
        sKeyPressedArrayIndex = 0;
        sKeyReleasedArrayIndex = 0;
        sChangeScrollIndex = 0;
    }

    public static final void addKeyPressed(int n, int n2) {
        if (sKeyPressedIndex >= 512) {
            Replay.addKeyPressedArray();
            sKeyPressedIndex = 0;
            ++sKeyPressedArrayIndex;
        }
        Replay.getArray((Vector)Replay.sKeyPressedVector)[Replay.sKeyPressedIndex][0] = n;
        Replay.getArray((Vector)Replay.sKeyPressedVector)[Replay.sKeyPressedIndex][1] = n2;
        Replay.getArray((Vector)Replay.sKeyPressedVector)[Replay.sKeyPressedIndex][2] = n2 - sKeyPressedFrame;
        ++sKeyPressedIndex;
        sKeyPressedFrame = n2;
    }

    public static final void addKeyReleased(int n, int n2) {
        if (sKeyReleasedIndex >= 512) {
            Replay.addKeyReleasedArray();
            sKeyReleasedIndex = 0;
            ++sKeyReleasedArrayIndex;
        }
        Replay.getArray((Vector)Replay.sKeyReleasedVector)[Replay.sKeyReleasedIndex][0] = n;
        Replay.getArray((Vector)Replay.sKeyReleasedVector)[Replay.sKeyReleasedIndex][1] = n2;
        Replay.getArray((Vector)Replay.sKeyReleasedVector)[Replay.sKeyReleasedIndex][2] = n2 - sKeyReleasedFrame;
        ++sKeyReleasedIndex;
        sKeyReleasedFrame = n2;
    }

    public static final int getKeyPressed(int n) {
        return Replay.getArray(sKeyPressedVector)[n][0];
    }

    public static final int getKeyReleased(int n) {
        return Replay.getArray(sKeyReleasedVector)[n][0];
    }

    public static final int getKeyPressedFrame(int n) {
        return sKeyPressedFrame;
    }

    public static final void updateKeyPressedFrame(int n) {
        sKeyPressedFrame += Replay.getArray(sKeyPressedVector)[n][2];
    }

    public static final int getKeyPressedTotalFrame(int n) {
        return Replay.getArray(sKeyPressedVector)[n][1];
    }

    public static final int getKeyReleasedFrame(int n) {
        return sKeyReleasedFrame;
    }

    public static final void updateKeyReleasedFrame(int n) {
        sKeyReleasedFrame += Replay.getArray(sKeyReleasedVector)[n][2];
    }

    public static final int getKeyReleasedTotalFrame(int n) {
        return Replay.getArray(sKeyReleasedVector)[n][1];
    }

    public static final void addKey(Vector vector, int n, int n2) {
        if (n2 > 0) {
            int[] nArray = Replay.getArray(vector)[n2];
            nArray[0] = nArray[0] | n;
        } else {
            int[] nArray = ((int[][])vector.elementAt(vector.size() - 1))[n2];
            nArray[0] = nArray[0] | n;
        }
    }

    public static final void calculateReplayLength() {
        int n;
        int n2;
        sNumPressedMoves = 0;
        sNumReleasedMoves = 0;
        int n3 = Menu.getAvailReplaySpace(3);
        if ((n3 -= 24) <= 0) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        block0: for (n2 = 0; n2 < sKeyPressedVector.size(); ++n2) {
            for (n = 0; n < ((int[][])sKeyPressedVector.elementAt(n2)).length; ++n) {
                int[] nArray = ((int[][])sKeyPressedVector.elementAt(n2))[n];
                if (n3 >> 1 < (n5 += 2)) continue block0;
                ++sNumPressedMoves;
                n4 += nArray[2];
            }
        }
        n2 = 0;
        block2: for (n = 0; n < sKeyReleasedVector.size(); ++n) {
            for (int i = 0; i < ((int[][])sKeyReleasedVector.elementAt(n)).length; ++i) {
                int[] nArray = ((int[][])sKeyReleasedVector.elementAt(n))[i];
                if (n2 > n4) continue block2;
                ++sNumReleasedMoves;
                n2 += nArray[2];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void save() {
        Replay.calculateReplayLength();
        if (sNumPressedMoves == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte by;
            int[] nArray;
            int n;
            int n2;
            int n3;
            dataOutputStream.writeInt(Game.sGameDifficulty);
            dataOutputStream.writeInt(Game.sCurrentSeed);
            dataOutputStream.writeInt(Game.sGameStyle);
            dataOutputStream.writeInt(Avatar.character);
            dataOutputStream.writeInt(GameBoard.sStartingFloorStyle);
            dataOutputStream.writeInt(Keys.sAutoJump);
            dataOutputStream.writeInt(GameBoard.getScore());
            dataOutputStream.writeInt(Game.sMaxFloors);
            dataOutputStream.writeInt(Game.sMaxCombos);
            for (n3 = 0; n3 < sChangeScrollFrames.length; ++n3) {
                dataOutputStream.writeInt(sChangeScrollFrames[n3]);
            }
            dataOutputStream.writeInt(sNumPressedMoves);
            n3 = 0;
            byte[] byArray = new byte[2];
            block6: for (n2 = 0; n2 < sKeyPressedVector.size(); ++n2) {
                for (n = 0; n < ((int[][])sKeyPressedVector.elementAt(n2)).length; ++n) {
                    nArray = ((int[][])sKeyPressedVector.elementAt(n2))[n];
                    byArray[0] = (byte)(nArray[2] - 128 & 0xFF);
                    by = (byte)(nArray[2] >> 8 & 0x1F);
                    byArray[1] = (byte)(by << 3);
                    byArray[1] = (byte)(byArray[1] | nArray[0] & 7);
                    ((OutputStream)dataOutputStream).write(byArray);
                    if (++n3 > sNumPressedMoves) continue block6;
                }
            }
            dataOutputStream.writeInt(sNumReleasedMoves);
            n3 = 0;
            block8: for (n2 = 0; n2 < sKeyReleasedVector.size(); ++n2) {
                for (n = 0; n < ((int[][])sKeyReleasedVector.elementAt(n2)).length; ++n) {
                    nArray = ((int[][])sKeyReleasedVector.elementAt(n2))[n];
                    byArray[0] = (byte)(nArray[2] - 128 & 0xFF);
                    by = (byte)(nArray[2] >> 8 & 0x1F);
                    byArray[1] = (byte)(by << 3);
                    byArray[1] = (byte)(byArray[1] | nArray[0] & 7);
                    ((OutputStream)dataOutputStream).write(byArray);
                    if (++n3 > sNumReleasedMoves) continue block8;
                }
            }
            dataOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Menu.saveReplay(byArray2);
        }
        catch (Exception exception) {
        }
        finally {
            RM.closeStream(dataOutputStream);
        }
        sKeyPressedIndex = 0;
        sKeyReleasedIndex = 0;
    }

    private static void cleanArray(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray[i][j] = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void load(byte[] byArray) {
        DataInputStream dataInputStream = RM.getDataInput(byArray);
        try {
            int[][] nArray;
            int n;
            int n2;
            int n3;
            int n4;
            Game.sGameDifficulty = dataInputStream.readInt();
            sRandomSeed = dataInputStream.readInt();
            Game.sGameStyle = dataInputStream.readInt();
            Avatar.character = dataInputStream.readInt();
            GameBoard.sStartingFloorStyle = dataInputStream.readInt();
            Keys.sAutoJump = dataInputStream.readInt();
            Game.sSavedScore = dataInputStream.readInt();
            Game.sSavedFloors = dataInputStream.readInt();
            Game.sSavedCombos = dataInputStream.readInt();
            for (n4 = 0; n4 < sChangeScrollFrames.length; ++n4) {
                Replay.sChangeScrollFrames[n4] = dataInputStream.readInt();
            }
            n4 = dataInputStream.readInt();
            Replay.cleanArray(Replay.getArray(sKeyPressedVector));
            sKeyPressedIndex = 0;
            byte[] byArray2 = new byte[2];
            for (n3 = 0; n3 < n4; ++n3) {
                dataInputStream.read(byArray2);
                n2 = byArray2[0] + 128 | (byArray2[1] & 0xF8) << 5;
                n = byArray2[1] & 7;
                nArray = (int[][])sKeyPressedVector.elementAt(sKeyPressedArrayIndex);
                nArray[Replay.sKeyPressedIndex][0] = n;
                nArray[Replay.sKeyPressedIndex][1] = 0;
                nArray[Replay.sKeyPressedIndex][2] = n2;
                if (++sKeyPressedIndex != 512) continue;
                Replay.addKeyPressedArray();
                sKeyPressedIndex = 0;
                ++sKeyPressedArrayIndex;
            }
            n4 = dataInputStream.readInt();
            Replay.cleanArray(Replay.getArray(sKeyReleasedVector));
            sKeyReleasedIndex = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                dataInputStream.read(byArray2);
                n2 = byArray2[0] + 128 | (byArray2[1] & 0xF8) << 5;
                n = byArray2[1] & 7;
                nArray = (int[][])sKeyReleasedVector.elementAt(sKeyReleasedArrayIndex);
                nArray[Replay.sKeyReleasedIndex][0] = n;
                nArray[Replay.sKeyReleasedIndex][1] = 0;
                nArray[Replay.sKeyReleasedIndex][2] = n2;
                if (++sKeyReleasedIndex != 512) continue;
                Replay.addKeyReleasedArray();
                sKeyReleasedIndex = 0;
                ++sKeyReleasedArrayIndex;
            }
            sLoadError = false;
        }
        catch (Exception exception) {
            sLoadError = true;
            sStringError = exception.getMessage();
        }
        finally {
            RM.closeStream(dataInputStream);
        }
        sKeyPressedIndex = 0;
        sKeyReleasedIndex = 0;
    }

    static {
        sChangeScrollIndex = 0;
        sKeyPressedVector = new Vector();
        sKeyReleasedVector = new Vector();
        sKeyPressedFrame = 0;
        sKeyReleasedFrame = 0;
        sKeyPressedArrayIndex = 0;
        sKeyReleasedArrayIndex = 0;
        sKeyPressedIndex = 0;
        sKeyReleasedIndex = 0;
        sRandomSeed = 0;
        sNumPressedMoves = 0;
        sNumReleasedMoves = 0;
    }
}

