/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.mmapi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import tinbrain.ISound;
import tinbrain.RM;

public class Sound
implements ISound,
PlayerListener {
    private Player player;
    private int activeTune;
    private boolean looped;
    private boolean isMenu;
    private int restartTune = -1;
    private int volumeMusic;
    private int volumeSFX;
    private int lastTune;
    private int delayedTune;
    private static String[] formats = new String[11];

    public void play(int n, boolean bl, boolean bl2) {
        if (n != this.activeTune || !this.looped) {
            this.restartTune = -1;
            this.stop();
        }
        this.looped = bl2;
        this.isMenu = bl;
        int n2 = bl ? this.volumeMusic : this.volumeSFX;
        int n3 = bl ? 0 : 0;
        this.playFresh(n, bl2, n2, n3);
        this.lastTune = n;
    }

    private void playFresh(int n, boolean bl, int n2, int n3) {
        block5: {
            if (n2 > 0 && this.player == null) {
                try {
                    this.player = this.createPlayer(n, n3);
                    if (this.player == null) break block5;
                    try {
                        this.player.setMediaTime(0L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.player.start();
                    this.updateVolume();
                    this.activeTune = this.isMenu ? n : -1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Player createPlayer(int n, int n2) {
        Player player;
        ByteArrayInputStream byteArrayInputStream;
        block5: {
            byteArrayInputStream = null;
            player = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(RM.getBytes(n));
                player = Manager.createPlayer((InputStream)byteArrayInputStream, (String)formats[n2]);
                if (!Sound.realizePlayer(player)) {
                    player = null;
                }
                if (player == null) break block5;
                player.setLoopCount(this.looped ? -1 : 1);
                player.prefetch();
            }
            catch (Exception exception) {
                RM.closeStream(byteArrayInputStream);
                catch (Throwable throwable) {
                    RM.closeStream(byteArrayInputStream);
                    throw throwable;
                }
            }
        }
        RM.closeStream(byteArrayInputStream);
        return player;
    }

    private static final boolean realizePlayer(Player player) {
        boolean bl = false;
        try {
            player.realize();
            bl = true;
        }
        catch (MediaException mediaException) {
            System.gc();
        }
        return bl;
    }

    public void stop() {
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = true;
            if (bl) {
                this.deallocate();
            }
        }
        this.activeTune = -1;
        this.player = null;
        System.gc();
    }

    private void deallocate() {
        this.deallocate(this.player);
        this.player = null;
        System.gc();
    }

    private void deallocate(Player player) {
        if (player != null) {
            try {
                player.deallocate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                player.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setVolume(int n, int n2) {
        this.volumeMusic = n;
        this.volumeSFX = n2;
        this.updateVolume();
    }

    private void updateVolume() {
        int n;
        if (this.player != null && (n = this.player.getState()) == 400) {
            int n2;
            int n3 = n2 = this.isMenu ? this.volumeMusic : this.volumeSFX;
            if (n2 > 0) {
                try {
                    VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
                    volumeControl.setLevel(n2);
                }
                catch (Exception exception) {}
            } else {
                this.stop();
            }
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string == "endOfMedia") {
            this.stop();
        }
    }

    public void tick() {
        if (this.delayedTune > 0) {
            this.play(this.delayedTune, this.isMenu, this.looped);
            this.delayedTune = 0;
        }
    }

    static {
        Sound.formats[0] = "audio/midi";
        Sound.formats[3] = "audio/x-mid";
        Sound.formats[4] = "audio/sp-midi";
        Sound.formats[6] = "audio/amr";
        Sound.formats[5] = "audio/x-wav";
        Sound.formats[8] = "audo/mmf";
    }
}

