/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Combo;
import game.Game;
import tinbrain.GCanvas;
import tinbrain.RM;

public class ComboIndicator {
    private static int sPosX;
    private static int sPosY;
    private static int sStripePosX;
    private static int sStripePosY;
    private static int sStripeWidth;
    private static int sStripeHeight;
    private static int imageId;
    private static int sCurrentStripeHeight;

    public static final void init() {
        imageId = Game.sGameStyle == 0 ? 40 : 52;
        sPosX = RM.getValue(69, Game.sGameStyle, 0);
        sPosY = RM.getValue(69, Game.sGameStyle, 1);
        sStripePosX = RM.getValue(69, Game.sGameStyle, 2);
        sStripePosY = RM.getValue(69, Game.sGameStyle, 3);
        sStripeWidth = RM.getValue(69, Game.sGameStyle, 4);
        sCurrentStripeHeight = sStripeHeight = RM.getValue(69, Game.sGameStyle, 5);
    }

    public static final void resetStripe() {
        sCurrentStripeHeight = sStripeHeight;
    }

    public static final void update() {
        int n = (int)((long)Game.frameCount - Combo.getStartTime());
        if (n >= 34) {
            ComboIndicator.resetStripe();
        } else {
            sCurrentStripeHeight = n * sStripeHeight / 34;
        }
    }

    public static final void draw() {
        GCanvas.drawImage(imageId, sPosX, sPosY, 0);
        ComboIndicator.drawStripe();
    }

    private static final void drawStripe() {
        GCanvas.getTargetGraphics().setColor(0);
        GCanvas.getTargetGraphics().fillRect(sPosX + sStripePosX, sPosY + sStripePosY, sStripeWidth, sCurrentStripeHeight);
    }
}

