/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Avatar;
import game.Clock;
import game.Combo;
import game.ComboIndicator;
import game.CustomFonts;
import game.GameBoard;
import game.Keys;
import game.RandomGenerator;
import game.Replay;
import game.StarsEffect;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.util.GL;

public class Game {
    public static int DIFFICULTY_EASY = 0;
    public static int DIFFICULTY_HARD;
    public static int sGameDifficulty;
    public static int sSavedScore;
    public static int sSavedFloors;
    public static int sSavedCombos;
    public static Random random;
    public static long sAllFrameTime;
    public static int sCurrentSeed;
    public static int sGameStyle;
    public static boolean sPermitJump;
    public static boolean sModeReplay;
    public static boolean sDisplayJumpUp;
    public static long sStartTime;
    public static boolean sStartTimeIsSet;
    public static int frameCount;
    private static boolean waitForPlayer;
    public static int sCurrentFloor;
    public static int sScreenHeight;
    public static boolean sFastScroll;
    public static boolean sGameOver;
    public static boolean sMoveLeftStarted;
    public static boolean sMoveRightStarted;
    public static boolean sMoveUpStarted;
    public static int sMaxCombos;
    public static int sMaxFloors;
    public static boolean sPauseReplay;
    public static long sPauseStartTime;
    public static int sCheatScrollSpeed;
    private static int sCheatComboMsgIndex;
    static long sStartTimeTemp;
    static boolean sReplayOver;
    private static int lastFrame;
    private static boolean sHelpMenuTextIsPrepared;
    private static int sOutroTimer;
    private static int sSwitchToOutroTimer;
    private static int sDisplayTutorial;
    private static boolean sIsTutorialVisible;
    private static boolean sEndDemo;

    private Game() {
    }

    public static final boolean isInGame() {
        return !waitForPlayer;
    }

    public static final void onDraw(Graphics graphics) {
        if (sDisplayTutorial != -1) {
            return;
        }
        graphics.setClip(0, 0, GCanvas.getGameWidth(), GCanvas.getGameHeight());
        Clock.drawMessage();
        GameBoard.draw(graphics);
        Avatar.draw();
        ComboIndicator.draw();
        Combo.drawMessage();
        StarsEffect.draw();
        Clock.draw();
        GameBoard.drawScore(graphics);
        Combo.drawComboLength();
        if (GCanvas.cheatEnabled(4)) {
            Game.drawCheatComboMessages();
        }
        Game.drawSoftButtons();
        Game.drawFingerprint(graphics);
    }

    private static final void drawFingerprint(Graphics graphics) {
        if (GCanvas.cheatEnabled(2)) {
            graphics.setFont(GCanvas.FONT_SMALL);
            graphics.setColor(0);
            int n = GCanvas.getStringWidth("HOM            ") + 2;
            graphics.fillRect(0, 0, n, GCanvas.getFontHeight());
            graphics.setColor(-1);
            graphics.drawString("HOM            ", 1, 0, 0);
        }
    }

    private static void drawCheatComboMessages() {
        waitForPlayer = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = Combo.getMessage1(Combo.comboLengths[sCheatComboMsgIndex]);
        String string2 = Combo.getMessage2(Combo.comboLengths[sCheatComboMsgIndex]);
        n = GCanvas.getGameWidth() - CustomFonts.getStringWidth(string) >> 1;
        n3 = GCanvas.getGameWidth() - CustomFonts.getStringWidth(string2) >> 1;
        n2 = GCanvas.getGameHeight() - CustomFonts.getFontHeight() >> 1;
        CustomFonts.drawString(GCanvas.getTargetGraphics(), string, n, n2 - CustomFonts.getFontHeight());
        CustomFonts.drawString(GCanvas.getTargetGraphics(), string2, n3, n2);
    }

    public static void correctingTimes(long l) {
        int n = (int)(l - sPauseStartTime);
        sStartTimeTemp += (long)n;
        if (Combo.sStartTimeMsg != 0L) {
            Combo.sStartTimeMsg += (long)n;
        }
    }

    public static Font getFont(int n) {
        switch (n) {
            case 0: {
                return GCanvas.FONT_SMALL;
            }
            case 1: {
                return GCanvas.FONT_MEDIUM;
            }
        }
        return GCanvas.FONT_LARGE;
    }

    public static boolean anySteeringKeyPressed() {
        return GCanvas.isKeyPressed(Keys.sKeys[4]) || GCanvas.isKeyPressed(Keys.sKeys[0]) || GCanvas.isKeyPressed(Keys.sKeys[1]) || GCanvas.isKeyPressed(Keys.sKeys[3]) || GCanvas.isKeyPressed(Keys.sKeys[2]);
    }

    private static final void handleKeyPressed(int n, boolean bl) {
        if (Replay.sKeyPressedIndex > 0) {
            boolean bl2;
            if (bl) {
                bl2 = Replay.getKeyPressedTotalFrame(Replay.sKeyPressedIndex - 1) == frameCount;
            } else {
                boolean bl3 = bl2 = Replay.getKeyPressedFrame(Replay.sKeyPressedIndex - 1) == frameCount;
            }
            if (bl2) {
                Replay.addKey(Replay.sKeyPressedVector, n, Replay.sKeyPressedIndex - 1);
            } else {
                Replay.addKeyPressed(n, frameCount);
            }
        } else {
            Replay.addKeyPressed(n, frameCount);
        }
    }

    private static final void keyHandling() {
        if (GCanvas.isKeyPressed(Keys.sKeys[4]) && !sMoveUpStarted && sPermitJump) {
            Game.handleKeyPressed(4, true);
            sDisplayJumpUp = false;
            sMoveUpStarted = true;
        }
        if (GCanvas.isKeyPressed(Keys.sKeys[2]) && !GCanvas.isKeyPressed(Keys.sKeys[3])) {
            if (!sMoveLeftStarted && sPermitJump) {
                Game.handleKeyPressed(1, false);
                sMoveLeftStarted = true;
            }
            if (!sMoveUpStarted && sPermitJump) {
                Game.handleKeyPressed(4, false);
                sDisplayJumpUp = true;
                sMoveUpStarted = true;
            }
        } else if (!GCanvas.isKeyPressed(Keys.sKeys[0])) {
            sMoveLeftStarted = Game.keyReleased(1, sMoveLeftStarted);
        }
        if (GCanvas.isKeyPressed(Keys.sKeys[0]) && !GCanvas.isKeyPressed(Keys.sKeys[1])) {
            if (!sMoveLeftStarted) {
                Game.handleKeyPressed(1, true);
                sMoveLeftStarted = true;
            }
        } else if (!GCanvas.isKeyPressed(Keys.sKeys[2])) {
            sMoveLeftStarted = Game.keyReleased(1, sMoveLeftStarted);
        }
        if (GCanvas.isKeyPressed(Keys.sKeys[3]) && !GCanvas.isKeyPressed(Keys.sKeys[2])) {
            if (!sMoveRightStarted && sPermitJump) {
                Game.handleKeyPressed(2, false);
                sMoveRightStarted = true;
            }
            if (!sMoveUpStarted && sPermitJump) {
                Game.handleKeyPressed(4, false);
                sDisplayJumpUp = true;
                sMoveUpStarted = true;
            }
        } else if (!GCanvas.isKeyPressed(Keys.sKeys[1])) {
            sMoveRightStarted = Game.keyReleased(2, sMoveRightStarted);
        }
        if (GCanvas.isKeyPressed(Keys.sKeys[1]) && !GCanvas.isKeyPressed(Keys.sKeys[0])) {
            if (!sMoveRightStarted) {
                Game.handleKeyPressed(2, true);
                sMoveRightStarted = true;
            }
        } else if (!GCanvas.isKeyPressed(Keys.sKeys[3])) {
            sMoveRightStarted = Game.keyReleased(2, sMoveRightStarted);
        }
        if (GCanvas.isLastKeyReleased(Keys.sKeys[0]) || GCanvas.isLastKeyReleased(Keys.sKeys[2])) {
            sMoveLeftStarted = Game.keyReleased(1, sMoveLeftStarted);
        }
        if (GCanvas.isLastKeyReleased(Keys.sKeys[4]) || GCanvas.isLastKeyReleased(Keys.sKeys[2]) || GCanvas.isLastKeyReleased(Keys.sKeys[3])) {
            sPermitJump = true;
        }
        if (GCanvas.isLastKeyReleased(Keys.sKeys[1]) || GCanvas.isLastKeyReleased(Keys.sKeys[3])) {
            sMoveRightStarted = Game.keyReleased(2, sMoveRightStarted);
        }
        if (GCanvas.cheatEnabled(3)) {
            if (GCanvas.isKeyPressed(32768)) {
                --sCheatScrollSpeed;
            }
            if (GCanvas.isKeyPressed(65536)) {
                ++sCheatScrollSpeed;
            }
        }
        if (GCanvas.cheatEnabled(4) && GCanvas.isKeyPressed(65536)) {
            sCheatComboMsgIndex = sCheatComboMsgIndex > 0 ? --sCheatComboMsgIndex : Combo.comboLengths.length - 1;
            GCanvas.resetKeys();
        }
        GCanvas.resetLastKeyReleased();
    }

    public static final void onInput() {
        if (sDisplayTutorial != -1) {
            Game.displayTutorial();
            return;
        }
        if (waitForPlayer) {
            Avatar.updateAnim();
            if (Game.anySteeringKeyPressed()) {
                waitForPlayer = false;
            }
        }
        if (waitForPlayer) {
            return;
        }
        if (!sModeReplay) {
            Game.keyHandling();
        }
        if (!sPauseReplay) {
            Game.doGameLogic();
            ++frameCount;
        }
    }

    public static final boolean keyReleased(int n, boolean bl) {
        if (bl) {
            if (Replay.sKeyReleasedIndex > 0) {
                if (Replay.getKeyReleasedTotalFrame(Replay.sKeyReleasedIndex - 1) == frameCount) {
                    Replay.addKey(Replay.sKeyReleasedVector, n, Replay.sKeyReleasedIndex - 1);
                } else {
                    Replay.addKeyReleased(n, frameCount);
                }
            } else {
                Replay.addKeyReleased(n, frameCount);
            }
            bl = false;
        }
        return bl;
    }

    public static void moveAvatar() {
        if (sMoveUpStarted) {
            if (Keys.sAutoJump == 0) {
                if (sPermitJump) {
                    Avatar.prepareToJump();
                }
            } else {
                Avatar.prepareToJump();
            }
            sMoveUpStarted = false;
        }
        Avatar.jump();
        if (sMoveLeftStarted) {
            Avatar.move(1);
        }
        if (sMoveRightStarted) {
            Avatar.move(2);
        }
        if (!sMoveLeftStarted && !sMoveRightStarted) {
            Avatar.brake();
        }
        Avatar.fall();
    }

    private static void replayService() {
        if (Replay.sKeyPressedIndex < 512 && frameCount == Replay.getKeyPressedFrame(Replay.sKeyPressedIndex)) {
            lastFrame = frameCount;
            if ((Replay.getKeyPressed(Replay.sKeyPressedIndex) & 1) == 1) {
                sMoveLeftStarted = true;
            }
            if ((Replay.getKeyPressed(Replay.sKeyPressedIndex) & 1) == 1 && (Replay.getKeyPressed(Replay.sKeyPressedIndex) & 4) == 4) {
                sDisplayJumpUp = true;
            }
            if ((Replay.getKeyPressed(Replay.sKeyPressedIndex) & 2) == 2) {
                sMoveRightStarted = true;
            }
            if ((Replay.getKeyPressed(Replay.sKeyPressedIndex) & 2) == 2 && (Replay.getKeyPressed(Replay.sKeyPressedIndex) & 4) == 4) {
                sDisplayJumpUp = true;
            }
            if ((Replay.getKeyPressed(Replay.sKeyPressedIndex) & 4) == 4) {
                sMoveUpStarted = true;
            }
            if (++Replay.sKeyPressedIndex == 512) {
                Replay.sKeyPressedIndex = 0;
                ++Replay.sKeyPressedArrayIndex;
            }
            if (Replay.sKeyPressedIndex < 512) {
                Replay.updateKeyPressedFrame(Replay.sKeyPressedIndex);
            }
        }
        if (Replay.sKeyReleasedIndex < 512 && frameCount == Replay.getKeyReleasedFrame(Replay.sKeyReleasedIndex)) {
            if ((Replay.getKeyReleased(Replay.sKeyReleasedIndex) & 1) == 1) {
                sMoveLeftStarted = false;
            }
            if ((Replay.getKeyReleased(Replay.sKeyReleasedIndex) & 2) == 2) {
                sMoveRightStarted = false;
            }
            if (++Replay.sKeyReleasedIndex == 512) {
                Replay.sKeyReleasedIndex = 0;
                ++Replay.sKeyReleasedArrayIndex;
            }
            if (Replay.sKeyReleasedIndex < 512) {
                Replay.updateKeyReleasedFrame(Replay.sKeyReleasedIndex);
            }
        }
        if (lastFrame == Replay.getKeyPressedFrame(Replay.sKeyPressedIndex) && lastFrame != 0) {
            sReplayOver = true;
            return;
        }
    }

    private static final void doGameLogic() {
        if (sEndDemo) {
            Menu.changeMenu(27, false);
        }
        if (sModeReplay) {
            Game.replayService();
        }
        Game.moveAvatar();
        if (Avatar.getPosY() < GCanvas.getGameHeight() / 4 && !sStartTimeIsSet) {
            sStartTime = frameCount;
            sStartTimeTemp = System.currentTimeMillis();
            sAllFrameTime = 0L;
            sStartTimeIsSet = true;
        }
        if (sStartTimeIsSet) {
            if (GCanvas.frameTime < 0L) {
                if (GCanvas.frameTime > 55L) {
                    sAllFrameTime += GCanvas.frameTime;
                } else if (System.currentTimeMillis() - sStartTimeTemp - sAllFrameTime < 0L) {
                    sAllFrameTime = System.currentTimeMillis() - sStartTimeTemp;
                } else {
                    sStartTimeTemp = System.currentTimeMillis() - sAllFrameTime;
                    sAllFrameTime += 55L;
                }
            } else {
                sAllFrameTime = System.currentTimeMillis() - sStartTimeTemp;
            }
        }
        sFastScroll = Avatar.getPosY() < GCanvas.getGameHeight() / 4;
        sCurrentFloor = GameBoard.getCurrentFloor(Avatar.getPosY());
        Avatar.updateAnim();
        if (sStartTimeIsSet) {
            GameBoard.update(sStartTime, sFastScroll);
            Avatar.update(sStartTime, sFastScroll);
        }
        GameBoard.calculateScore(sCurrentFloor);
        Combo.update();
        StarsEffect.update();
        Clock.update();
        if (GCanvas.cheatEnabled(5)) {
            GameBoard.sMaxFloor[0] = 10;
            GameBoard.sMaxFloor[1] = 10;
        }
        if (!GCanvas.cheatEnabled(3) && Avatar.getPosY() > GCanvas.getGameHeight() - Avatar.sAvatarHeight) {
            sGameOver = true;
            Avatar.setState(7);
            if (!sModeReplay) {
                sStartTimeIsSet = false;
                if (sMaxFloors / 100 > GameBoard.sMaxFloor[sGameStyle]) {
                    GameBoard.sMaxFloor[Game.sGameStyle] = sMaxFloors / 100;
                    if (GameBoard.sMaxFloor[sGameStyle] > 10) {
                        GameBoard.sMaxFloor[Game.sGameStyle] = 10;
                    }
                }
                if (sGameDifficulty == DIFFICULTY_EASY) {
                    Menu.newHighscoreCandidate(0, GameBoard.getScore(), null, 1, sMaxFloors, null, 2, sMaxCombos, null);
                } else {
                    Menu.newHighscoreCandidate(3, GameBoard.getScore(), null, 4, sMaxFloors, null, 5, sMaxCombos, null);
                }
            } else if (sReplayOver) {
                sStartTimeIsSet = false;
                if (Avatar.getPosY() > GCanvas.getGameHeight()) {
                    sGameStyle = Menu.sTempGameStyle;
                    Avatar.character = Menu.sTempCharacter;
                    GameBoard.sStartingFloorStyle = Menu.sTempStartingFloorStyle;
                    Keys.sAutoJump = Menu.sTempRejumpOption;
                    if (Menu.sWatchingLoadedReplay) {
                        Menu.changeMenu(10, false);
                    } else {
                        Menu.changeMenu(18, true);
                    }
                }
            }
        }
    }

    public static final void init() {
        if (Menu.getOption(17) == 0) {
            Game.displayTutorial(0);
        }
    }

    public static final int getTimeSeed() {
        long l = System.currentTimeMillis();
        return (int)(l & Integer.MAX_VALUE);
    }

    public static final void initReplay() {
        sModeReplay = true;
        Replay.initPlayback();
        Replay.updateKeyPressedFrame(0);
        Replay.updateKeyReleasedFrame(0);
    }

    public static final void initGame(boolean bl) {
        if (bl) {
            Menu.startLoading(142);
        }
        if (random == null) {
            random = new Random();
        }
        CustomFonts.initFonts();
        sScreenHeight = GCanvas.getGameHeight();
        StarsEffect.init();
        Clock.init();
        if (sModeReplay) {
            sCurrentSeed = Replay.sRandomSeed;
        } else {
            sCurrentSeed = Game.getTimeSeed();
            Replay.initVector();
            Replay.sRandomSeed = sCurrentSeed;
        }
        RandomGenerator.setSeed(sCurrentSeed);
        ComboIndicator.init();
        GameBoard.init();
        Avatar.init();
        Game.restart();
        sCurrentFloor = GameBoard.getCurrentFloor(Avatar.getPosY());
        if (bl) {
            Menu.stopLoading();
        }
    }

    public static final void restart() {
        if (sModeReplay) {
            GCanvas.setSoftButton(14, 9, true);
        } else {
            GCanvas.setSoftButton(-1, 9, true);
        }
        sReplayOver = false;
        lastFrame = 0;
        sAllFrameTime = 0L;
        sCheatComboMsgIndex = Combo.comboLengths.length - 1;
        sCheatScrollSpeed = 0;
        sPermitJump = true;
        sPauseReplay = false;
        sMaxFloors = 0;
        sMaxCombos = 0;
        sGameOver = false;
        waitForPlayer = !sModeReplay;
        sMoveLeftStarted = false;
        sMoveRightStarted = false;
        sMoveUpStarted = false;
        sFastScroll = false;
        sStartTimeIsSet = false;
        frameCount = 0;
        if (!sModeReplay) {
            Replay.restart();
        }
        Clock.restart();
        GameBoard.restart();
        Combo.restart();
        Avatar.restart();
        StarsEffect.removeAllStars();
        StarsEffect.update();
    }

    public static final void notify(boolean bl) {
        if (bl) {
            sMoveLeftStarted = Game.keyReleased(1, sMoveLeftStarted);
            sMoveRightStarted = Game.keyReleased(2, sMoveRightStarted);
            sPermitJump = true;
            if (sModeReplay) {
                GCanvas.setSoftButton(14, 9, true);
            } else {
                GCanvas.setSoftButton(-1, 9, true);
            }
        }
    }

    private static void drawSoftButtons() {
        int n;
        byte by;
        GCanvas.getTargetGraphics().setColor(-1);
        GCanvas.getTargetGraphics().setFont(GCanvas.softButtonFont);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (GCanvas.leftSoftButton != -1) {
            by = GCanvas.softkeys[GCanvas.leftSoftButton][2];
            if (by < 0) {
                n = RM.getShortFromBytes(GCanvas.softkeys[GCanvas.leftSoftButton], 0);
                GCanvas.getTargetGraphics().drawString(RM.t(n), 3, GCanvas.getGameHeight() - 1 + 2 + 0, 36);
            } else {
                n2 = 3;
                n3 = GCanvas.getGameHeight() - 1;
                n4 = 36;
                GCanvas.drawImage(by, n2, n3, true, n4);
            }
        }
        if (GCanvas.rightSoftButton != -1) {
            by = GCanvas.softkeys[GCanvas.rightSoftButton][2];
            if (by < 0) {
                n = RM.getShortFromBytes(GCanvas.softkeys[GCanvas.rightSoftButton], 0);
                GCanvas.getTargetGraphics().drawString(RM.t(n), GCanvas.getWidth() - 3, GCanvas.getGameHeight() - 1 + 2 + 0, 40);
            } else {
                n2 = GCanvas.getWidth() - 3;
                n3 = GCanvas.getGameHeight() - 1;
                n4 = 40;
                GCanvas.drawImage(by, n2, n3, true, n4);
            }
        }
    }

    public static final void setOptionDefaults() {
    }

    public static final void performMenuAction(int n, int n2) {
        switch (n) {
            case 10: {
                Game.forgetGameRes();
                Menu.changeMenu(7, false);
                break;
            }
            case 9: {
                Game.forgetGameRes();
                if (GL.handsonDemoIsActive()) {
                    Menu.changeMenu(27, false);
                    break;
                }
                Menu.changeMenu(7, false);
                break;
            }
            case 8: {
                Game.forgetGameRes();
                if (GL.handsonDemoIsActive()) {
                    Menu.changeMenu(27, false);
                    break;
                }
                Menu.performMenuAction(37);
            }
        }
    }

    public static final boolean evaluateCondition(int n) {
        switch (n) {
            case 8: {
                return GL.handsonDemoIsActive();
            }
            case 10: {
                return !GL.handsonDemoIsActive();
            }
            case 6: {
                if (GL.handsonDemoIsActive()) {
                    return false;
                }
                return GL.handsonMoreGamesIsMenu();
            }
            case 7: {
                if (GL.handsonDemoIsActive()) {
                    GL.handsonMoreGamesReadBuySetup();
                    return GL.handsonMoreGamesIsMenu();
                }
                return false;
            }
            case 17: {
                return Game.isInGame();
            }
            case 11: {
                return GL.handsonLanguageIsAvailable(0);
            }
            case 12: {
                return GL.handsonLanguageIsAvailable(1);
            }
            case 13: {
                return GL.handsonLanguageIsAvailable(2);
            }
            case 14: {
                return GL.handsonLanguageIsAvailable(3);
            }
            case 15: {
                return GL.handsonLanguageIsAvailable(4);
            }
            case 16: {
                return GL.handsonLanguageIsAvailable(5);
            }
        }
        return true;
    }

    private static final void prepareAboutScreen() {
        RM.prepareVarText(2, new String[]{Menu.getMidletInfo(0), Menu.getMidletInfo(1), Menu.getMidletInfo(0), Menu.getMidletInfo(0)});
    }

    private static final void prepareHelpMenuText(boolean bl) {
        if (sHelpMenuTextIsPrepared && !bl) {
            return;
        }
        sHelpMenuTextIsPrepared = true;
        String[] stringArray = new String[3];
        if (GL.handsonDemoIsActive()) {
            if (GL.handsonMoreGamesIsMenu()) {
                RM.prepareVarText(16, RM.t(23));
                stringArray[0] = RM.t(130);
                stringArray[1] = RM.t(131);
                stringArray[2] = RM.t(16);
                RM.prepareVarText(18, stringArray);
            } else {
                stringArray[0] = RM.t(130);
                stringArray[1] = RM.t(131);
                stringArray[2] = "";
                RM.prepareVarText(18, stringArray);
            }
        } else if (GL.handsonMoreGamesIsMenu()) {
            RM.prepareVarText(17, RM.t(23));
            stringArray[0] = RM.t(130);
            stringArray[1] = RM.t(131);
            stringArray[2] = RM.t(17);
            RM.prepareVarText(18, stringArray);
        } else {
            stringArray[0] = RM.t(130);
            stringArray[1] = RM.t(131);
            stringArray[2] = "";
            RM.prepareVarText(18, stringArray);
        }
    }

    private static final void prepareMenuExpiredScreen() {
        int n = 154;
        if (GL.handsonMoreGamesGetUrl() == null) {
            Menu.setSoftkeys(27, -1, 26);
            n = 155;
        } else {
            Menu.setSoftkeys(27, 25, 26);
        }
        RM.prepareVarText(25, Menu.getMidletInfo(0), RM.t(n));
    }

    public static final void onPrepareMenuChange(int n, int n2) {
        Menu.setMenuCaptionImage(-1, true);
        boolean bl = n != 7;
        Menu.showUpDownArrows(bl);
        switch (n) {
            case 7: {
                Menu.stopMusic();
                sOutroTimer = 5000;
                if (GL.handsonDemoIsActive()) {
                    Menu.setMenuOption(7, 3, (byte)-1);
                    Menu.setMenuOption(7, 4, (byte)-1);
                    sOutroTimer = 2000;
                } else if (GL.handsonMoreGamesIsExit()) {
                    Menu.setMenuOption(7, 3, (byte)33);
                }
                Menu.setMenuCaptionImage(-1);
                break;
            }
            case 6: {
                Game.prepareAboutScreen();
                break;
            }
            case 15: {
                break;
            }
            case 27: {
                sSwitchToOutroTimer = 5000;
                Game.prepareMenuExpiredScreen();
                break;
            }
            case 28: {
                Game.prepareMenuExpiredScreen();
                break;
            }
        }
    }

    private static final void forgetGameRes() {
        RM.forget(RM.modernGame);
        RM.forget(RM.classicGame);
    }

    public static final void onLanguageChanged() {
        GL.handsonDemoInit("P3TG0TJ0H");
        GL.handsonMoreGamesReadLabel();
        if (GL.sHandsonMoreGamesLabel == null || GL.sHandsonMoreGamesLabel.length() == 0) {
            GL.sHandsonMoreGamesLabel = GL.handsonDemoIsActive() ? new String(RM.t(157)) : new String(RM.t(146));
        }
        RM.prepareVarText(23, GL.sHandsonMoreGamesLabel);
        Game.prepareHelpMenuText(true);
    }

    public static final void menuDrawItem(Graphics graphics, Font font, int n, String string, int n2, int n3, int n4) {
        Menu.drawMenuItem(graphics, font, n, string, n2, n3, n4);
    }

    private static final void menuDrawOutroScreen(int n, int n2, int n3, int n4) {
        Graphics graphics = GCanvas.getTargetGraphics();
        graphics.setColor(-1);
        graphics.fillRect(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        GCanvas.drawImage(1, GCanvas.getWidth() - RM.getWidth(1) >> 1, (GCanvas.getHeight() - RM.getHeight(1) >> 1) + 0, 0);
        GCanvas.drawImage(5, GCanvas.getWidth() >> 1, 0, 17);
        int n5 = 0;
        n5 = RM.getImage(5).getHeight() + 1;
        GCanvas.drawImage(6, GCanvas.getWidth() >> 1, n5, 17);
    }

    public static final boolean menuProcessActions() {
        switch (Menu.getCurrentMenu()) {
            case 27: {
                if ((sSwitchToOutroTimer -= 55) >= 0) break;
                Menu.performMenuAction(10);
                return true;
            }
            case 7: {
                if ((sOutroTimer -= 55) >= 0) break;
                Menu.performMenuAction(37);
                return true;
            }
        }
        return false;
    }

    public static final void drawCustomMenuBackground(int n, int n2, int n3, int n4) {
        switch (n) {
            case 7: {
                Game.menuDrawOutroScreen(n, n2, n3, n4);
                break;
            }
            default: {
                Game.menuDrawStandardBackground(n, n2, n3, n4);
            }
        }
    }

    public static final void drawBackgroundImage() {
        GCanvas.drawImage(25, GCanvas.width >> 1, GCanvas.height >> 1, 3);
    }

    private static void menuDrawStandardBackground(int n, int n2, int n3, int n4) {
        Game.drawBackgroundImage();
        switch (n) {
            case 0: {
                Game.drawHead();
                GCanvas.drawImage(26, GCanvas.getWidth() - RM.getWidth(26) >> 1, 2, 20);
                break;
            }
            case -1: 
            case 34: {
                Game.drawHead();
                break;
            }
            default: {
                if (n == 16 || n == 17) break;
                Game.drawHead();
            }
        }
    }

    private static final void drawHead() {
        int n = RM.getLength(75);
        int n2 = RM.getInts(75)[GCanvas.getGlobalFrameCount() % n];
        int n3 = (Menu.MENU_SEPERATOR_BOTTOM << 10) + n2;
        int n4 = GCanvas.getWidth() - RM.getWidth(27);
        GCanvas.drawImage(27, n4, n3 >> 10, true, 36);
    }

    public static int calcPercentage(int n, int n2) {
        int n3 = GCanvas.div(n2 << 10, 102400);
        return GCanvas.mul(n << 10, n3) >> 10;
    }

    public static final void showTutorialMessage(int n) {
        Game.setTutorialVisible(true);
        sPauseStartTime = System.currentTimeMillis();
        Menu.selectedItem = 0;
        Menu.showMessage(147, n, 12, -1, false);
    }

    public static final void setTutorialVisible(boolean bl) {
        sIsTutorialVisible = bl;
    }

    public static final boolean isTutorialVisible() {
        return sIsTutorialVisible;
    }

    static final void displayTutorial(int n) {
        sDisplayTutorial = n;
    }

    static final boolean hasTutorialBeenDisplayed(int n) {
        switch (n) {
            case 0: {
                return Menu.getOption(17) == 1;
            }
            case 1: {
                return Menu.getOption(18) == 1;
            }
        }
        return false;
    }

    private static void displayTutorial() {
        switch (sDisplayTutorial) {
            case 0: {
                if (Menu.getOption(17) != 0) break;
                Menu.setOption(17, 1);
                String[] stringArray = new String[]{Keys.getKeyString(Keys.sKeys[4])};
                RM.prepareVarText(24, stringArray);
                Game.showTutorialMessage(24);
                break;
            }
            case 1: {
                if (Menu.getOption(18) != 0) break;
                Menu.setOption(18, 1);
                Game.showTutorialMessage(148);
            }
        }
        sDisplayTutorial = -1;
    }

    public static final int menuDrawSelectionBar(Graphics graphics, int n, int n2, int n3) {
        if (Menu.getCurrentMenu() == 7) {
            return n;
        }
        if (n3 == 23) {
            if (n == -1) {
                return -1;
            }
            return -3407872;
        }
        return n;
    }

    public static String readMoreGamesUrl() {
        return GL.handsonMoreGamesReadUrl();
    }

    private static boolean demoIsDemoExpired() {
        return GameBoard.getCurrentFloor(Avatar.getPosY()) + 1 > 50;
    }

    private static void demoPrintIngameDemoMode(Graphics graphics) {
        if (Menu.getCurrentMenu() == 7) {
            return;
        }
        if (GCanvas.getGlobalFrameCount() % 20 > 10) {
            graphics.setFont(GCanvas.FONT_SMALL);
            int n = 1;
            int n2 = 1;
            int n3 = 20;
            if (Menu.mode == 2) {
                n += 0;
                n2 += 0;
            }
            graphics.setColor(-16777216);
            graphics.drawString(RM.t(152), n - 1, n2 - 1, n3);
            graphics.drawString(RM.t(152), n + 1, n2 - 1, n3);
            graphics.drawString(RM.t(152), n - 1, n2 + 1, n3);
            graphics.drawString(RM.t(152), n + 1, n2 + 1, n3);
            graphics.setColor(-256);
            graphics.drawString(RM.t(152), n, n2, n3);
        }
    }

    private static void demoPrintMenuDemoMode(Graphics graphics) {
        Game.demoPrintIngameDemoMode(graphics);
    }

    public static void demoHandleDemoMode(Graphics graphics) {
        if (!GL.handsonDemoIsActive()) {
            return;
        }
        if (Menu.getMode() == 2) {
            if (Game.demoIsDemoExpired()) {
                sEndDemo = true;
            } else {
                Game.demoPrintIngameDemoMode(graphics);
            }
        } else {
            Game.demoPrintMenuDemoMode(graphics);
        }
    }

    public static final void drawSoftkeyLabels(Graphics graphics, int n, int n2, String string, int n3) {
        if (Menu.getCurrentMenu() == 7) {
            graphics.setColor(-16777216);
            graphics.drawString(string, n, n2, n3);
        } else {
            graphics.setColor(-1);
            graphics.drawString(string, n, n2, n3);
        }
    }

    static {
        sGameDifficulty = DIFFICULTY_HARD = 1;
        sCurrentSeed = 0;
        sGameStyle = 0;
        sPermitJump = true;
        lastFrame = 0;
        sHelpMenuTextIsPrepared = false;
        sOutroTimer = 0;
        sSwitchToOutroTimer = 0;
        sDisplayTutorial = -1;
        sIsTutorialVisible = false;
        sEndDemo = false;
    }
}

