/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.Star;
import java.util.Vector;
import tinbrain.GCanvas;
import tinbrain.RM;

public class StarsEffect {
    private static Vector mStars;
    private static int mStarSpeedX;
    private static int mStarSpeedY;
    private static int mStarSpriteId;
    private static int mNoOfFrames;

    public static void init() {
        mStars = new Vector();
        mStarSpeedX = RM.getValue(62, Game.sGameStyle, 0);
        mNoOfFrames = RM.getValue(62, Game.sGameStyle, 3);
        mStarSpeedY = RM.getValue(62, Game.sGameStyle, 1);
        mStarSpriteId = RM.getValue(62, Game.sGameStyle, 2);
    }

    public static void removeAllStars() {
        if (mStars != null) {
            mStars.removeAllElements();
        }
    }

    public static void addStar(int n, int n2) {
        if (mStars != null) {
            int n3 = Game.random.nextInt() % mStarSpeedX;
            mStars.addElement(new Star(n, n2, n3));
        }
    }

    public static void update() {
        if (mStars != null && mStars.size() > 0) {
            for (int i = 0; i < mStars.size(); ++i) {
                Star star = (Star)mStars.elementAt(i);
                star.update(mStarSpeedY);
                star.setFrame(Math.abs(Game.random.nextInt() % mNoOfFrames));
                if (star.getYpos() <= GCanvas.getGameHeight()) continue;
                mStars.removeElementAt(i);
            }
        }
    }

    public static void draw() {
        if (mStars != null) {
            for (int i = 0; i < mStars.size(); ++i) {
                ((Star)mStars.elementAt(i)).drawStar(mStarSpriteId);
            }
        }
    }
}

