/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import game.Game;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import tinbrain.Menu;
import tinbrain.Midlet;
import tinbrain.RM;
import tinbrain.midp20.ACanvas;
import tinbrain.midp20.MIDP20Proxy;

public class GCanvas
implements Runnable {
    protected static volatile boolean isRunning;
    public static final int[][] bounds;
    public static final int[][] boundsLetters;
    public static int currentTouchedButton;
    public static boolean touchButtonPressed;
    public static int currentTouchedLetter;
    private static int globalFrameCount;
    private static long uptimeMillis;
    public static int width;
    public static int height;
    private static boolean forcedSize;
    private static int lastKeyReleased;
    private static int keyStatesUp;
    public static int keyStatesDown;
    private static int keyStates;
    private static Canvas canvas;
    private static Graphics deviceGraphics;
    private static Graphics targetGraphics;
    public static boolean backBufferEnabled;
    public static final Font FONT_LARGE;
    public static final Font FONT_MEDIUM;
    public static final Font FONT_SMALL;
    public static final int FONT_LARGE_HEIGHT;
    public static final int FONT_MEDIUM_HEIGHT;
    public static final int FONT_SMALL_HEIGHT;
    private static int softkeyPressed;
    public static byte[][] softkeys;
    public static int leftSoftButton;
    public static int rightSoftButton;
    public static Font softButtonFont;
    public static boolean hideSoftKeys;
    public static boolean swapSoftKeys;
    private static final int[][] clipStack;
    private static int clipStackPtr;
    private static final int[] tmpClip;
    private static final int[] tmpRect;
    public static long frameTime;
    private static long lastFrameTime;
    private static long lastDrawTime;
    private static int frameTimeCount;
    private static String fpsMessage;
    private static String tmpMessage;
    private static int tmpMessageTime;
    private static int cheatFlags;
    private static final int[] cheatBase;
    private static int cheatPosition;
    private static long current;
    private static long last;
    private static long delay;
    private static boolean inputDone;
    public static final Random random;
    public static final int[] xPoints;
    public static final int[] yPoints;

    protected static final void setForcedSize(int n, int n2) {
        if (n != width || n2 != height) {
            GCanvas.setSize(n, n2);
            forcedSize = true;
        }
    }

    public static final void setSize(int n, int n2) {
        if (!forcedSize) {
            width = n;
            height = n2;
        }
    }

    public static final void init(MIDlet mIDlet) {
        canvas = new ACanvas();
        Display.getDisplay((MIDlet)mIDlet).setCurrent((Displayable)canvas);
    }

    private static final void updateInput() {
        keyStates = keyStatesDown;
        keyStatesDown &= ~keyStatesUp;
        keyStatesUp = 0;
    }

    public static final void resetKeys() {
        softkeyPressed = 0;
        keyStatesUp = 0;
        keyStatesDown = 0;
        keyStates = 0;
    }

    public static final int getSoftkeys() {
        int n = softkeyPressed;
        softkeyPressed = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void drawScene(Graphics graphics) {
        deviceGraphics = graphics;
        targetGraphics = graphics;
        Graphics graphics2 = graphics;
        synchronized (graphics2) {
            GCanvas.doDrawScene(graphics);
        }
    }

    private static void doDrawScene(Graphics graphics) {
        targetGraphics.setClip(0, 0, width, height);
        try {
            Menu.onDraw(targetGraphics);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!hideSoftKeys) {
            GCanvas.drawSoftButtons();
        }
        long l = System.currentTimeMillis();
        if (GCanvas.cheatEnabled(1)) {
            if (--frameTimeCount == 0) {
                frameTimeCount = 16;
                int n = (int)(l - lastFrameTime);
                lastFrameTime = l;
                if ((n >>= 4) > 0) {
                    int n2 = 1024000 / n + 512 >> 10;
                    fpsMessage = Integer.toString(n2);
                }
            }
            if (fpsMessage != null) {
                targetGraphics.setColor(-1);
                targetGraphics.setFont(FONT_SMALL);
                targetGraphics.drawString(fpsMessage, 20, 20, 20);
            }
        }
        GCanvas.updateUptime(l);
        if (tmpMessageTime > 0) {
            targetGraphics.setColor(-16777216);
            targetGraphics.fillRect(0, (height >> 1) - 2, width, FONT_SMALL_HEIGHT + 4);
            targetGraphics.setColor(-1);
            targetGraphics.setFont(FONT_SMALL);
            targetGraphics.drawString(tmpMessage, width >> 1, height >> 1, 17);
            --tmpMessageTime;
        }
        ++globalFrameCount;
        inputDone = false;
    }

    private static final void updateUptime(long l) {
        if (canvas.isShown()) {
            long l2 = Math.abs(l - lastDrawTime);
            if (l2 < 880L) {
                uptimeMillis += l2;
            }
            lastDrawTime = l;
        }
    }

    private static void drawSoftButtons() {
        String string;
        int n;
        int n2;
        int n3;
        int n4;
        byte by;
        if (leftSoftButton != -1) {
            by = softkeys[leftSoftButton][2];
            n4 = 3;
            n3 = height - 1 + 0;
            n2 = 36;
            if (by < 0) {
                n = RM.getShortFromBytes(softkeys[leftSoftButton], 0);
                string = RM.t(n);
                targetGraphics.setFont(softButtonFont);
                Game.drawSoftkeyLabels(targetGraphics, n4, n3, string, n2);
            } else {
                GCanvas.drawImage(by, n4, n3, true, n2);
            }
        }
        if (rightSoftButton != -1) {
            by = softkeys[rightSoftButton][2];
            n4 = width - 3;
            n3 = height - 1 + 0;
            n2 = 40;
            if (by < 0) {
                n = RM.getShortFromBytes(softkeys[rightSoftButton], 0);
                string = RM.t(n);
                targetGraphics.setFont(softButtonFont);
                Game.drawSoftkeyLabels(targetGraphics, n4, n3, string, n2);
            } else {
                GCanvas.drawImage(by, n4, n3, true, n2);
            }
        }
    }

    public static final boolean cheatEnabled(int n) {
        return (cheatFlags & 1 << n) != 0;
    }

    public static final void showTemporaryMessage(String string) {
        tmpMessage = string;
        tmpMessageTime = 30;
        GCanvas.redraw();
        Thread.yield();
    }

    public static final long getUptimeMillis() {
        return uptimeMillis;
    }

    public static final void tick() {
        if (!inputDone) {
            try {
                GCanvas.updateInput();
                Menu.onInput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            inputDone = true;
        }
        if (inputDone) {
            GCanvas.redraw();
        }
        current = System.currentTimeMillis();
        frameTime = Math.abs(current - last);
        delay = GCanvas.clamp(55L - frameTime, 2L, 55L);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        last = System.currentTimeMillis();
    }

    public static final void redraw() {
        if (canvas != null) {
            canvas.repaint();
            canvas.serviceRepaints();
        }
    }

    public static final void idleTick() {
        GCanvas.updateUptime(System.currentTimeMillis());
    }

    public static final void keyPressed(int n) {
        int n2 = GCanvas.getVKey(n);
        if (Menu.getMode() != 0) {
            if (cheatPosition == cheatBase.length) {
                for (int i = 0; i < 6; ++i) {
                    if (n2 != RM.getValue(7, i, 0)) continue;
                    GCanvas.toggleCheat(i);
                    break;
                }
                cheatPosition = 0;
            }
            cheatPosition = cheatBase[cheatPosition] == n2 ? ++cheatPosition : 0;
        }
        if (n2 != 0) {
            keyStatesDown |= n2;
        } else {
            if (n == -6) {
                softkeyPressed |= swapSoftKeys ? 262144 : 131072;
            }
            if (n == -7) {
                softkeyPressed |= swapSoftKeys ? 131072 : 262144;
            }
        }
    }

    public static final void toggleCheat(int n) {
        int n2;
        int n3 = 1 << n;
        if ((cheatFlags & n3) != 0) {
            cheatFlags &= ~n3;
            n2 = 103;
        } else {
            cheatFlags |= n3;
            n2 = 102;
        }
        GCanvas.showTemporaryMessage(RM.t(RM.getValue(7, n, 1)) + " " + RM.t(n2));
        Menu.refreshMenu();
    }

    public static final void keyReleased(int n) {
        lastKeyReleased = keyStatesUp |= GCanvas.getVKey(n);
    }

    public static final boolean isLastKeyReleased(int n) {
        return (lastKeyReleased & n) != 0;
    }

    public static final void resetLastKeyReleased() {
        lastKeyReleased = 0;
    }

    public static final boolean anyKey() {
        return keyStatesDown != 0;
    }

    public static final boolean consumeAnyKey() {
        if (GCanvas.anyKey()) {
            GCanvas.resetKeys();
            return true;
        }
        return GCanvas.getSoftkeys() != 0;
    }

    public static final boolean isKeyPressed(int n) {
        return (keyStates & n) != 0;
    }

    public static final boolean isUP() {
        return (0x81 & keyStates) != 0;
    }

    public static final boolean isRIGHT() {
        return (0x802 & keyStates) != 0;
    }

    public static final boolean isDOWN() {
        return (0x2004 & keyStates) != 0;
    }

    public static final boolean isLEFT() {
        return (0x208 & keyStates) != 0;
    }

    public static final boolean isFIRE() {
        return (0x410 & keyStates) != 0;
    }

    public static final boolean consumeKey(int n) {
        if (GCanvas.isKeyPressed(n)) {
            keyStatesDown &= ~n;
            return true;
        }
        return false;
    }

    public static final boolean consumeUP() {
        if (GCanvas.isUP()) {
            keyStatesDown &= 0xFFFFFF7E;
            return true;
        }
        return false;
    }

    public static final boolean consumeDOWN() {
        if (GCanvas.isDOWN()) {
            keyStatesDown &= 0xFFFFDFFB;
            return true;
        }
        return false;
    }

    public static final boolean consumeLEFT() {
        if (GCanvas.isLEFT()) {
            keyStatesDown &= 0xFFFFFDF7;
            return true;
        }
        return false;
    }

    public static final boolean consumeRIGHT() {
        if (GCanvas.isRIGHT()) {
            keyStatesDown &= 0xFFFFF7FD;
            return true;
        }
        return false;
    }

    public static final boolean consumeFIRE() {
        if (GCanvas.isFIRE()) {
            keyStatesDown &= 0xFFFFFBEF;
            return true;
        }
        return false;
    }

    private static final int mapVKey(int n, boolean bl) {
        if (bl) {
            // empty if block
        }
        switch (n) {
            case 48: {
                return 32;
            }
            case 49: {
                return 64;
            }
            case 50: {
                return 128;
            }
            case 51: {
                return 256;
            }
            case 52: {
                return 512;
            }
            case 53: {
                return 1024;
            }
            case 54: {
                return 2048;
            }
            case 55: {
                return 4096;
            }
            case 56: {
                return 8192;
            }
            case 57: {
                return 16384;
            }
            case 42: {
                return 32768;
            }
            case 35: {
                return 65536;
            }
        }
        return 0;
    }

    private static final int checkDPAD(int n) {
        int n2 = 0;
        try {
            n2 = canvas.getGameAction(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (n2) {
            case 1: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 8: {
                return 16;
            }
        }
        return 0;
    }

    private static final int getVKey(int n) {
        int n2;
        boolean bl = false;
        if (Menu.menus != null && Menu.getMenuType(Menu.currentMenu) != 3) {
            bl = true;
        }
        if ((n2 = GCanvas.mapVKey(n, bl)) != 0) {
            return n2;
        }
        int n3 = n;
        if (n3 == -6 || n3 == -7) {
            return 0;
        }
        if (n3 == -5) {
            return 16;
        }
        return GCanvas.checkDPAD(n);
    }

    public static final void hideNotify() {
        try {
            Menu.doPause();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void showNotify() {
    }

    public void run() {
        isRunning = true;
        lastDrawTime = last = System.currentTimeMillis();
        uptimeMillis = last;
        while (isRunning) {
            GCanvas.tick();
        }
        Midlet.instance.notifyDestroyed();
    }

    public static final void setSoftButton(int n, int n2, boolean bl) {
        boolean bl2 = swapSoftKeys;
        leftSoftButton = bl2 ? n2 : n;
        rightSoftButton = bl2 ? n : n2;
    }

    public static final void drawImage(int n, int n2, int n3, int n4) {
        GCanvas.drawImage(targetGraphics, n, n2, n3, true, n4);
    }

    public static final void drawImage(int n, int n2, int n3, boolean bl, int n4) {
        GCanvas.drawImage(targetGraphics, n, n2, n3, bl, n4);
    }

    public static final void drawImage(Graphics graphics, int n, int n2, int n3, boolean bl, int n4) {
        int n5 = RM.getType(n);
        if (n5 == 1) {
            graphics.drawImage(RM.getImage(n), n2, n3, n4);
            return;
        }
        if (n5 == 4) {
            int n6 = RM.getWidth(n);
            MIDP20Proxy.drawImage(graphics, RM.getInts(n), n2, n3, n6, RM.getHeight(n), n6, bl, n4);
            return;
        }
        if (n5 == 5) {
            return;
        }
    }

    public static final void drawSprite(int n, int n2, int n3, int n4) {
        GCanvas.drawSprite(targetGraphics, n, n2, n3, n4);
    }

    public static final void initSprites() {
        byte[] byArray = RM.getBytes(60);
        for (int i = 0; i < 21; ++i) {
            int n = i * 5;
            byte by = byArray[n + 0];
            if (by < 0) continue;
            int n2 = byArray[n + 2];
            int n3 = byArray[n + 3];
            byte by2 = byArray[n + 1];
            int n4 = RM.getWidth(by);
            int n5 = RM.getHeight(by);
            int n6 = n5 / by2;
            int n7 = 0;
            int n8 = 0;
            n7 = n2 == -2 ? n4 >> 1 : (n2 == -3 ? n4 : n2);
            n8 = n3 == -2 ? n6 >> 1 : (n3 == -5 ? n6 : n3);
            byArray[n + 4] = (byte)n6;
            byArray[n + 2] = (byte)n7;
            byArray[n + 3] = (byte)n8;
        }
    }

    public static final void drawSprite(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = RM.getBytes(60);
        int n5 = n * 5;
        byte by = byArray[n5 + 0];
        byte by2 = byArray[n5 + 2];
        byte by3 = byArray[n5 + 3];
        byte by4 = byArray[n5 + 4];
        int n6 = RM.getWidth(by);
        n2 -= by2;
        n3 -= by3;
        if (graphics != targetGraphics) {
            GCanvas.pushClip(graphics);
            graphics.clipRect(n2, n3, n6, (int)by4);
            GCanvas.drawImage(graphics, by, n2, n3 - n4 * by4, true, 20);
            GCanvas.popClip(graphics);
        } else {
            GCanvas.pushClip();
            if (GCanvas.clipRect(n2, n3, n6, by4)) {
                GCanvas.drawImage(by, n2, n3 - n4 * by4, 20);
            }
            GCanvas.popClip();
        }
    }

    public static final int getSpriteWidth(int n) {
        return RM.getWidth(RM.getValue(60, n, 0));
    }

    public static final int getSpriteHeight(int n) {
        return RM.getValue(60, n, 4);
    }

    public static final int getSpriteFrames(int n) {
        return RM.getValue(60, n, 1);
    }

    public static final int mul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 10);
    }

    public static final int div(int n, int n2) {
        return (int)(((long)n << 10) / (long)n2);
    }

    public static final long clamp(long l, long l2, long l3) {
        return l < l2 ? l2 : (l > l3 ? l3 : l);
    }

    public static final int getSecond(int n) {
        return n % 60000 / 1000;
    }

    public static final Canvas getCanvas() {
        return canvas;
    }

    public static final Graphics getTargetGraphics() {
        return targetGraphics;
    }

    public static final int getGlobalFrameCount() {
        return globalFrameCount;
    }

    public static final int getWidth() {
        return width;
    }

    public static final int getHeight() {
        return height;
    }

    public static final int getGameHeight() {
        return height;
    }

    public static final int getGameWidth() {
        return width;
    }

    public static final void pushClip() {
        GCanvas.pushClip(targetGraphics);
    }

    public static final void pushClip(Graphics graphics) {
        int[] nArray = clipStack[++clipStackPtr];
        RM.setRect(nArray, graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
    }

    public static final boolean clipRect(int n, int n2, int n3, int n4) {
        return GCanvas.clipRect(targetGraphics, n, n2, n3, n4);
    }

    public static final boolean clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = clipStack[clipStackPtr];
        RM.setRect(tmpClip, nArray);
        GCanvas.clipRect(tmpClip, n, n2, n3, n4);
        GCanvas.setClip(graphics, tmpClip);
        return !RM.isRectEmpty(tmpClip);
    }

    public static final void popClip() {
        GCanvas.popClip(targetGraphics);
    }

    public static final void popClip(Graphics graphics) {
        GCanvas.setClip(graphics, clipStack[clipStackPtr--]);
    }

    public static final void clipRect(int[] nArray, int n, int n2, int n3, int n4) {
        RM.setRect(tmpRect, n, n2, n3, n4);
        RM.intersectRect(nArray, tmpRect);
    }

    public static final void setClip(Graphics graphics, int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        GCanvas.setClip(graphics, n, n2, n3 - n, n4 - n2);
    }

    public static final void setClip(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
    }

    public static final int getStringWidth(String string) {
        return RM.getStringWidth(string, targetGraphics.getFont());
    }

    public static final int getFontHeight() {
        return targetGraphics.getFont().getHeight();
    }

    static {
        bounds = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {67, 0, 76, 98}, {0, 0, 65, 98}, {144, 0, 65, 98}};
        boundsLetters = new int[][]{{0, 0, 20, 23}, {22, 0, 20, 23}, {44, 0, 20, 23}, {66, 0, 20, 23}, {88, 0, 20, 23}, {110, 0, 20, 23}, {132, 0, 20, 23}, {154, 0, 20, 23}, {176, 0, 20, 23}, {0, 25, 20, 23}, {22, 25, 20, 23}, {44, 25, 20, 23}, {66, 25, 20, 23}, {88, 25, 20, 23}, {110, 25, 20, 23}, {132, 25, 20, 23}, {154, 25, 20, 23}, {176, 25, 20, 23}, {0, 50, 20, 23}, {22, 50, 20, 23}, {44, 50, 20, 23}, {66, 50, 20, 23}, {88, 50, 20, 23}, {110, 50, 20, 23}, {132, 50, 20, 23}, {154, 50, 20, 23}, {176, 50, 20, 23}};
        currentTouchedButton = 0;
        touchButtonPressed = false;
        currentTouchedLetter = 0;
        backBufferEnabled = true;
        FONT_LARGE = Font.getFont((int)64, (int)1, (int)16);
        FONT_MEDIUM = Font.getFont((int)64, (int)1, (int)0);
        FONT_SMALL = Font.getFont((int)64, (int)1, (int)0);
        FONT_LARGE_HEIGHT = RM.getFontHeight(FONT_LARGE);
        FONT_MEDIUM_HEIGHT = RM.getFontHeight(FONT_MEDIUM);
        FONT_SMALL_HEIGHT = RM.getFontHeight(FONT_SMALL);
        leftSoftButton = -1;
        rightSoftButton = -1;
        softButtonFont = FONT_SMALL;
        clipStack = new int[8][4];
        clipStackPtr = -1;
        tmpClip = new int[4];
        tmpRect = new int[4];
        frameTimeCount = 16;
        cheatBase = new int[]{65536, 128, 32, 32};
        random = new Random();
        xPoints = new int[64];
        yPoints = new int[64];
    }
}

