/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import game.Avatar;
import game.Game;
import game.GameBoard;
import game.Keys;
import game.Replay;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import tinbrain.GCanvas;
import tinbrain.ISound;
import tinbrain.Midlet;
import tinbrain.RM;
import tinbrain.midp20.MIDP20Proxy;
import tinbrain.mmapi.Sound;
import tinbrain.util.GL;

public class Menu
implements CommandListener {
    private static String forcedLang;
    public static int sTempGameStyle;
    public static int sTempCharacter;
    public static int sTempStartingFloorStyle;
    public static int sTempRejumpOption;
    public static boolean sWatchingLoadedReplay;
    private static int sDefiningKey;
    private static boolean sReplayExist;
    private static boolean runFirstTime;
    private static String exitURL;
    private static boolean soundDefault;
    private static boolean vibraDefault;
    private static boolean soundPresent;
    private static String[] midletInfo;
    protected static byte[][] menus;
    protected static byte[][][] menuItems;
    protected static byte[] iconBases;
    protected static byte[][] icons;
    private static boolean pausedOnSplash;
    private static long splashStartTime;
    private static int splashMaxTime;
    private static int currentSplash;
    private static int currentSplashTime;
    private static int currentSplashFrame;
    public static int mode;
    public static int splashMode;
    public static int currentMenu;
    public static int selectedItem;
    public static int visibleSelectedItem;
    public static int menuItemPosition;
    public static int menuItemEase;
    private static byte[] menuCaller;
    private static byte[] menuSelection;
    private static int[] menuItemWidths;
    private static boolean paused;
    public static int menuClipTop;
    private static int menuClipBottom;
    private static int menuClipHeight;
    private static int menuItemPositionMax;
    private static boolean showUpArrow;
    private static boolean showDownArrow;
    private static boolean lskEnabled;
    private static boolean rskEnabled;
    private static byte[][] textScreenItems;
    private static int delayedMenu;
    private static int delayedMenuCountDown;
    private static String[] highscoreListNames;
    private static String[] highscoreListScores;
    private static String[][] localHighscoreNameTable;
    private static int[][] localHighscoreScoreTable;
    private static int localHighscoreScoresCandidateTable;
    private static int localHighscoreScoresCandidateScore;
    private static byte[] localHighscoreScoresCandidateData;
    private static int localHighscoreFloorsCandidateTable;
    private static int localHighscoreFloorsCandidateScore;
    private static byte[] localHighscoreFloorsCandidateData;
    private static int localHighscoreCombosCandidateTable;
    private static int localHighscoreCombosCandidateScore;
    private static byte[] localHighscoreCombosCandidateData;
    private static int inputType;
    private static int inputTypeName;
    private static int enterNamePos;
    private static int enterNameMax;
    public static StringBuffer connectedUserName;
    private static String tmpConnectedUserName;
    public static int MENU_ITEM_TOP;
    public static int MENU_ITEM_BOTTOM;
    private static int MENU_SCROLLTEXT_TOP;
    private static int MENU_SCROLLTEXT_BOTTOM;
    public static int MENU_SEPERATOR_TOP;
    public static int MENU_SEPERATOR_BOTTOM;
    public static int MENU_SEPERATOR_HEIGHT;
    private static int MENU_TEXT_WIDTH;
    private static String scrollText;
    private static int menuCaptionImage;
    private static int menuCaptionOffset;
    private static boolean menuCaptionAlignLeft;
    private static final int[][] scrInfo;
    protected static int[] options;
    private static volatile boolean showLoading;
    private static int loadingFrame;
    private static boolean titleMusicStarted;
    private static long soundSplashStart;
    private static int soundSplashTime;
    private static int soundSplashTimeHelper;
    private static ISound sound;
    private static Menu instance;
    public static int community;
    private static boolean uploadingPrevHighscore;
    private static boolean tryToUploadPrevHighscore;
    private static Font textScreenFont;
    private static int ttapCountdown;
    private static char ttapChar;
    private static int ttapPos;
    private static int ttapKey;
    private static char[][] ttap;
    private static int progressBarMax;
    private static int progressCurrent;
    private static TextBox sTextBox;
    private static Command sCmdOK;
    private static Command sCmdBack;
    private static boolean sOptionsNeedReset;
    static boolean highScores;
    static boolean highFloors;
    static boolean highCombos;
    static boolean saveOptions;
    static int rank1;
    static int rank2;
    static int rank3;
    private static boolean sShowUpDownArrows;

    private Menu() {
    }

    protected static void start() {
        instance = new Menu();
        Thread thread = new Thread(new GCanvas());
        thread.start();
    }

    protected static void stop() {
        if (GCanvas.isRunning) {
            Menu.startLoading(143);
            Menu.flushRMS();
            Menu.stopMusic();
            GCanvas.isRunning = false;
        }
    }

    protected static final void flushRMS() {
        RM.flushRMS();
    }

    protected static final void onDraw(Graphics graphics) {
        if (showLoading) {
            Menu.drawLoading(graphics);
        } else {
            switch (mode) {
                case 0: {
                    Menu.drawSplash(graphics);
                    break;
                }
                case 1: {
                    Menu.drawMenu(graphics, currentMenu);
                    break;
                }
                case 2: {
                    Game.onDraw(graphics);
                    break;
                }
            }
            Game.demoHandleDemoMode(graphics);
        }
    }

    private static final void handleSplash() {
        switch (splashMode) {
            case 0: {
                currentSplash = -1;
                Menu.advanceSplashMode();
                break;
            }
            case 1: {
                Menu.loadRMS();
                GL.handsonMoreGamesReadBuySetup();
                Menu.advanceSplashMode();
                break;
            }
            case 2: {
                if (RM.getNumResources() != 0) break;
                RM.load();
                break;
            }
            case 3: {
                GCanvas.initSprites();
                Menu.init();
                Menu.advanceSplashMode();
                break;
            }
            case 4: {
                Game.init();
                Menu.advanceSplashMode();
                break;
            }
            case 5: {
                Menu.updateSplash(Menu.skipSplash());
                break;
            }
            case 6: {
                if (options[2] == 5) {
                    Menu.changeMenu(31, false);
                    break;
                }
                Menu.advanceSplashMode();
                break;
            }
            case 7: {
                Menu.advanceSplashMode();
                break;
            }
            case 14: {
                if (soundPresent) {
                    Menu.prepareSoundSplash();
                    soundSplashStart = GCanvas.getUptimeMillis();
                    Menu.changeMenu(32, false);
                    break;
                }
                Menu.advanceSplashMode();
                break;
            }
            case 8: {
                Menu.advanceSplashMode();
                Menu.advanceSplashMode();
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                Menu.advanceSplashMode();
                break;
            }
            case 11: {
                if (currentSplash >= 0) {
                    Menu.updateSplash(Menu.skipSplash());
                    break;
                }
                Menu.startSplash(1, 2000);
                break;
            }
            case 12: {
                if (currentSplash >= 0) {
                    Menu.updateSplash(Menu.skipSplash());
                    break;
                }
                Menu.startSplash(2, 2000);
                break;
            }
            case 13: {
                if (currentSplash >= 0) {
                    Menu.updateSplash(Menu.skipSplash());
                    break;
                }
                Menu.startSplash(3, 2000);
                break;
            }
            case 15: {
                int n = 0;
                Menu.changeMenu(n, false);
            }
        }
    }

    private static final boolean skipSplash() {
        return GCanvas.consumeAnyKey();
    }

    private static final void startSplash(int n, int n2) {
        splashStartTime = GCanvas.getUptimeMillis();
        splashMaxTime = n2;
        currentSplash = n;
        int n3 = Menu.getSplashID(currentSplash - 1);
        if (n3 >= 0) {
            RM.forget(n3);
        }
        RM.load(Menu.getSplashID(currentSplash));
        GCanvas.redraw();
    }

    private static final void updateSplash(boolean bl) {
        if (bl) {
            Menu.splashFinished();
        } else {
            currentSplashTime = (int)(GCanvas.getUptimeMillis() - splashStartTime);
            if (currentSplashTime > splashMaxTime) {
                Menu.splashFinished();
            }
        }
    }

    private static void splashFinished() {
        if (currentSplash >= 0) {
            Menu.advanceSplashMode();
            int n = Menu.getSplashID(currentSplash);
            if (n >= 0) {
                RM.forget(n);
            }
            currentSplash = -1;
        }
    }

    protected static final void onInput() {
        if (showLoading) {
            return;
        }
        if (mode == 0) {
            Menu.handleSplash();
            return;
        }
        if (sound != null) {
            sound.tick();
        }
        if (Menu.processSoftKeys() || Game.menuProcessActions()) {
            return;
        }
        if (mode == 2) {
            if (delayedMenuCountDown < 0) {
                Game.onInput();
            } else if (--delayedMenuCountDown == 0) {
                if (saveOptions) {
                    Menu.saveOptions();
                }
                Menu.changeMenu(delayedMenu, false);
            } else if (Game.sGameOver && Avatar.sAvatarYPos <= GCanvas.getHeight()) {
                Game.moveAvatar();
            }
        }
        if (mode == 1) {
            int n = Menu.getMenuType(currentMenu);
            if (n != 3 && currentMenu != 21) {
                if (GCanvas.consumeUP()) {
                    Menu.setSelection(currentMenu, selectedItem - 1, -1, false);
                }
                if (GCanvas.consumeDOWN()) {
                    Menu.setSelection(currentMenu, selectedItem + 1, 1, false);
                }
                if (GCanvas.consumeFIRE()) {
                    Menu.menuItemSelected();
                }
                if (selectedItem >= 0 && selectedItem < menuItems[currentMenu].length && menuItems[currentMenu][selectedItem][2] == 47) {
                    if (GCanvas.consumeLEFT()) {
                        Menu.menuItemChanged(-1);
                    }
                    if (GCanvas.consumeRIGHT()) {
                        Menu.menuItemChanged(1);
                    }
                }
                if (currentMenu == 32) {
                    soundSplashTime = (int)(GCanvas.getUptimeMillis() - soundSplashStart);
                    if (soundSplashTime >= 9999) {
                        ++splashMode;
                        Menu.changeMode(0);
                    } else {
                        Menu.prepareSoundSplash();
                        Menu.refreshMenu();
                    }
                }
            } else if (currentMenu != 21) {
                boolean bl = false;
                if (!bl) {
                    Menu.enterNameInput();
                    if (currentMenu == -1) {
                        if (!Menu.isBufferEmpty(Menu.getEnterNameBuffer().toString())) {
                            GCanvas.setSoftButton(menus[currentMenu][3], menus[currentMenu][4], true);
                            lskEnabled = true;
                            rskEnabled = true;
                        } else {
                            GCanvas.setSoftButton(-1, -1, true);
                            lskEnabled = false;
                            rskEnabled = false;
                        }
                    } else if (currentMenu == 34) {
                        if (Menu.isBufferEmpty(Menu.getEnterNameBuffer().toString())) {
                            GCanvas.setSoftButton(-1, menus[currentMenu][4], true);
                            lskEnabled = false;
                            rskEnabled = true;
                        } else {
                            GCanvas.setSoftButton(menus[currentMenu][3], menus[currentMenu][4], true);
                            lskEnabled = true;
                            rskEnabled = true;
                        }
                    }
                }
            } else if (currentMenu == 21) {
                Menu.enterKeyInput();
            }
        }
    }

    private static void setNewKey(int n) {
        switch (sDefiningKey) {
            case 0: {
                Keys.sKeys[0] = 8 | n;
                break;
            }
            case 1: {
                Keys.sKeys[1] = 2 | n;
                break;
            }
            case 4: {
                Keys.sKeys[4] = 1 | n;
                break;
            }
            case 2: {
                Keys.sKeys[2] = n;
                break;
            }
            default: {
                Keys.sKeys[3] = n;
            }
        }
        for (int i = 0; i < Keys.sKeys.length; ++i) {
            if (i == sDefiningKey || (Keys.sKeys[i] & n) != n) continue;
            int n2 = i;
            Keys.sKeys[n2] = Keys.sKeys[n2] & ~n;
        }
    }

    private static void enterKeyInput() {
        int n = 0;
        if (GCanvas.consumeKey(32)) {
            n = 32;
        } else if (GCanvas.consumeKey(64)) {
            n = 64;
        } else if (GCanvas.consumeKey(128)) {
            n = 128;
        } else if (GCanvas.consumeKey(256)) {
            n = 256;
        } else if (GCanvas.consumeKey(512)) {
            n = 512;
        } else if (GCanvas.consumeKey(1024)) {
            n = 1024;
        } else if (GCanvas.consumeKey(2048)) {
            n = 2048;
        } else if (GCanvas.consumeKey(4096)) {
            n = 4096;
        } else if (GCanvas.consumeKey(8192)) {
            n = 8192;
        } else if (GCanvas.consumeKey(16384)) {
            n = 16384;
        } else if (GCanvas.consumeKey(65536)) {
            n = 65536;
        } else if (GCanvas.consumeKey(32768)) {
            n = 32768;
        }
        if (n != 0) {
            Menu.setNewKey(n);
            Menu.options[11] = Keys.sKeys[0];
            Menu.options[12] = Keys.sKeys[1];
            Menu.options[15] = Keys.sKeys[4];
            Menu.options[13] = Keys.sKeys[2];
            Menu.options[14] = Keys.sKeys[3];
            Menu.saveOptions();
            Menu.performMenuAction(24);
        }
    }

    public static final void enterNameInput() {
    }

    private static final void drawEnterNameItem(Graphics graphics, Font font, String string, String string2, int n, int n2, int n3, int n4, int n5) {
        int n6 = font.charWidth('W') * 3;
        Menu.drawMenuItem(graphics, font, -11295068, string, n2, n3, 20);
        int n7 = 0;
        n3 += n5;
        graphics.setColor(-11295068);
        if ((GCanvas.getGlobalFrameCount() & 6) != 0) {
            graphics.setColor(0xFFFFFF);
        }
        graphics.drawRect(n2 + n7, n3 + 0, n6 + 5, n5 + 0);
        GCanvas.pushClip();
        GCanvas.clipRect(n2, n3, n4, n5 + 0);
        graphics.setColor(-11295068);
        int n8 = font.charWidth('W') * 3 + 5 - font.stringWidth(string2) >> 1;
        graphics.drawString(string2, n2 + 1 + 1 + n8 - n + n7, n3 + 1 + 1, 20);
        GCanvas.popClip();
    }

    private static final void drawHighscoreEntername(Graphics graphics, int n, StringBuffer stringBuffer, int n2, int n3) {
        int n4;
        Font font = GCanvas.FONT_MEDIUM;
        int n5 = 6;
        if (MENU_ITEM_BOTTOM - MENU_ITEM_TOP - n5 * (GCanvas.FONT_MEDIUM_HEIGHT + 2) < GCanvas.FONT_MEDIUM_HEIGHT + 2) {
            font = GCanvas.FONT_SMALL;
        }
        graphics.setFont(font);
        int n6 = graphics.getFont().getHeight() + 2;
        int n7 = 4;
        int n8 = MENU_ITEM_TOP + (MENU_ITEM_BOTTOM - MENU_ITEM_TOP - n5 * n6 >> 1);
        if (n8 <= MENU_ITEM_TOP) {
            n8 = MENU_ITEM_TOP + 1;
        }
        int n9 = MENU_TEXT_WIDTH - 1;
        int n10 = RM.getWidth(22);
        int n11 = RM.getHeight(22);
        int n12 = font.getHeight() > n11 ? (font.getHeight() - n11 >> 1) + 0 : (n11 - font.getHeight() >> 1) + 0;
        RM.prepareVarText(12, "" + GameBoard.getScore());
        RM.prepareVarText(13, "" + Game.sMaxFloors);
        RM.prepareVarText(14, "" + Game.sMaxCombos);
        int n13 = Math.max(0, font.stringWidth(RM.t(12)));
        n13 = Math.max(n13, font.stringWidth(RM.t(13)));
        n13 = Math.max(n13, font.stringWidth(RM.t(14)));
        Menu.drawMenuItem(graphics, font, -11295068, RM.t(12), n7, n8, 20);
        if (rank1 >= 0 && GameBoard.getScore() > 0) {
            GCanvas.drawImage(22, n7 + n13 + 0 + 2, n8 + n12, 20);
            Menu.drawMenuItem(graphics, font, -11295068, "" + (rank1 + 1), n7 + n13 + 0 + 4 + n10, n8 + 2, 20);
        }
        Menu.drawMenuItem(graphics, font, -11295068, RM.t(13), n7, n8 += n6, 20);
        if (rank2 >= 0 && Game.sMaxFloors > 0) {
            GCanvas.drawImage(22, n7 + n13 + 0 + 2, n8 + n12, 20);
            Menu.drawMenuItem(graphics, font, -11295068, "" + (rank2 + 1), n7 + n13 + 0 + 4 + n10, n8 + 2, 20);
        }
        Menu.drawMenuItem(graphics, font, -11295068, RM.t(14), n7, n8 += n6, 20);
        if (rank3 >= 0 && Game.sMaxCombos > 0) {
            GCanvas.drawImage(22, n7 + n13 + 0 + 2, n8 + n12, 20);
            Menu.drawMenuItem(graphics, font, -11295068, "" + (rank3 + 1), n7 + n13 + 0 + 4 + n10, n8 + 2, 20);
        }
        n8 = font == GCanvas.FONT_SMALL ? (n8 += n6) : (n8 += 2 * n6);
        String string = stringBuffer.toString().trim();
        char c = 'W';
        int n14 = 0;
        for (n4 = 0; n4 < enterNamePos; ++n4) {
            n14 += RM.getCharWidth(stringBuffer.charAt(n4), font);
        }
        n4 = 0;
        int n15 = n7 + n14 + 1;
        int n16 = ttapCountdown < 0 ? RM.getCharWidth(c, font) : RM.getCharWidth(ttapChar, font);
        if (n15 + n16 > n9) {
            n4 = n16 + n15 - n9;
        }
        n15 -= n4;
        String string2 = RM.t(Menu.getMenuItemCaption(menuItems[n2][0]));
        int n17 = n8;
        int n18 = font.charWidth('W') * 3 + 5 - font.stringWidth(string) >> 1;
        int n19 = 0;
        n17 = n8 + n6 + 5;
        n19 = 5;
        Menu.drawEnterNameItem(graphics, font, string2, string, n4, n7, n8 + n19, n9, n6);
        String string3 = string;
    }

    private static final void drawSummaryGame(Graphics graphics, int n) {
        int n2;
        Font font = GCanvas.FONT_MEDIUM;
        int n3 = 3;
        if (MENU_ITEM_BOTTOM - MENU_ITEM_TOP - n3 * (GCanvas.FONT_MEDIUM_HEIGHT + 2) < GCanvas.FONT_MEDIUM_HEIGHT + 2) {
            font = GCanvas.FONT_SMALL;
        }
        graphics.setFont(font);
        int n4 = graphics.getFont().getHeight() + 2;
        if (n4 * n3 > MENU_ITEM_BOTTOM - Menu.getMenuItemTop()) {
            n4 = graphics.getFont().getHeight() + 1;
        }
        int n5 = 4;
        int n6 = MENU_ITEM_TOP + (MENU_ITEM_BOTTOM - MENU_ITEM_TOP - n3 * n4 >> 1);
        int n7 = RM.getWidth(22);
        int n8 = RM.getHeight(22);
        int n9 = font.getHeight() > n8 ? (font.getHeight() - n8 >> 1) + 0 : (n8 - font.getHeight() >> 1) + 0;
        if (!Game.sModeReplay) {
            RM.prepareVarText(12, "" + GameBoard.getScore());
            RM.prepareVarText(13, "" + Game.sMaxFloors);
            RM.prepareVarText(14, "" + Game.sMaxCombos);
        } else {
            n2 = Game.sSavedScore > 0 ? Game.sSavedScore : GameBoard.getScore();
            int n10 = Game.sSavedFloors > 0 ? Game.sSavedFloors : Game.sMaxFloors;
            int n11 = Game.sSavedCombos > 0 ? Game.sSavedCombos : Game.sMaxCombos;
            RM.prepareVarText(12, "" + n2);
            RM.prepareVarText(13, "" + n10);
            RM.prepareVarText(14, "" + n11);
        }
        n2 = Math.max(0, font.stringWidth(RM.t(12)));
        n2 = Math.max(n2, font.stringWidth(RM.t(13)));
        n2 = Math.max(n2, font.stringWidth(RM.t(14)));
        Menu.drawMenuItem(graphics, font, -11295068, RM.t(12), n5, n6, 20);
        if (rank1 >= 0 && GameBoard.getScore() > 0 && !Game.sModeReplay) {
            GCanvas.drawImage(22, n5 + n2 + 0 + 2, n6 + n9, 20);
            GCanvas.getTargetGraphics().drawString("" + (rank1 + 1), n5 + n2 + 0 + 4 + n7, n6 + 2, 20);
        }
        Menu.drawMenuItem(graphics, font, -11295068, RM.t(13), n5, n6 += n4, 20);
        if (rank2 >= 0 && Game.sMaxFloors > 0 && !Game.sModeReplay) {
            GCanvas.drawImage(22, n5 + n2 + 0 + 2, n6 + n9, 20);
            GCanvas.getTargetGraphics().drawString("" + (rank2 + 1), n5 + n2 + 0 + 4 + n7, n6 + 2, 20);
        }
        Menu.drawMenuItem(graphics, font, -11295068, RM.t(14), n5, n6 += n4, 20);
        if (rank3 >= 0 && Game.sMaxCombos > 0 && !Game.sModeReplay) {
            GCanvas.drawImage(22, n5 + n2 + 0 + 2, n6 + n9, 20);
            GCanvas.getTargetGraphics().drawString("" + (rank3 + 1), n5 + n2 + 0 + 4 + n7, n6 + 2, 20);
        }
    }

    private static final int getInputNameLengthMax() {
        return 3;
    }

    private static final boolean isUsernameEmpty() {
        return Menu.getDisplayName(connectedUserName.toString(), false).length() == 0;
    }

    private static final void advanceSplashMode() {
        GCanvas.resetKeys();
        ++splashMode;
    }

    private static final void setInitialOptions(boolean bl) {
        if (options == null) {
            options = new int[24];
        }
        if (bl) {
            Menu.options[2] = 5;
        }
        Menu.options[16] = 1;
        Keys.sKeys[0] = 520;
        Menu.options[11] = 520;
        Keys.sKeys[1] = 2050;
        Menu.options[12] = 2050;
        Keys.sKeys[4] = 129;
        Menu.options[15] = 129;
        Keys.sKeys[2] = 64;
        Menu.options[13] = 64;
        Keys.sKeys[3] = 256;
        Menu.options[14] = 256;
        Menu.options[5] = 0;
        Menu.options[6] = 0;
        Menu.options[7] = 0;
        Menu.options[8] = 0;
        Menu.options[9] = 0;
        Menu.options[10] = 0;
        Game.sGameStyle = 0;
        Avatar.character = 0;
        GameBoard.sStartingFloorStyle = 0;
        GameBoard.sMaxFloor[0] = 0;
        GameBoard.sMaxFloor[1] = 0;
        if (bl) {
            Menu.options[16] = 1;
            Menu.options[11] = 520;
            Menu.options[12] = 2050;
            Menu.options[15] = 129;
            Menu.options[13] = 64;
            Menu.options[14] = 256;
            Menu.options[5] = 0;
            Menu.options[6] = 0;
            Menu.options[7] = 0;
            Menu.options[8] = 0;
            Menu.options[9] = 0;
            Menu.options[10] = 0;
            Menu.options[0] = soundDefault ? 50 : 0;
            Menu.options[1] = vibraDefault ? 1 : 0;
            connectedUserName = Menu.createInputBuffer("   ", 19, 0);
            Game.setOptionDefaults();
        }
    }

    public static final int getOption(int n) {
        return options[n];
    }

    public static final void setOption(int n, int n2) {
        Menu.options[n] = n2;
    }

    private static final StringBuffer createInputBuffer(String string, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.insert(0, string);
        stringBuffer.setLength(n2);
        for (n3 = string.length(); n3 < n2; ++n3) {
            stringBuffer.setCharAt(n3, ' ');
        }
        if (n > 0) {
            n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                Menu.options[i] = stringBuffer.charAt(i - n);
            }
        }
        return stringBuffer;
    }

    private static final void loadRMS() {
        String[] stringArray = new String[]{"opt", "his", "num", "rep1"};
        RM.initRMS(stringArray);
        Menu.loadReplay();
        options = RM.getRMSInts(0);
        if (RM.getRMSError() == 1) {
            Menu.setInitialOptions(true);
        } else if (options.length != 24) {
            RM.deleteRecordStore(0);
            Menu.setInitialOptions(true);
            RM.setStoreDirty(0);
        }
        Menu.loadHighscore();
        Game.sGameStyle = options[5];
        Avatar.character = options[6];
        GameBoard.sStartingFloorStyle = Game.sGameStyle == 0 ? options[7] : options[8];
        GameBoard.sMaxFloor[0] = options[9];
        GameBoard.sMaxFloor[1] = options[10];
        Keys.sAutoJump = options[16];
        Keys.sKeys[0] = options[11];
        Keys.sKeys[1] = options[12];
        Keys.sKeys[2] = options[13];
        Keys.sKeys[3] = options[14];
        Keys.sKeys[4] = options[15];
        int n = options[2];
        if (forcedLang != null) {
            RM.setLocale(forcedLang);
            Menu.options[2] = RM.languageIndex;
        } else {
            if (n == 5) {
                n = 0;
            }
            RM.setLocale(n);
        }
    }

    private static final void loadReplay() {
        Replay.initVector();
        byte[] byArray = null;
        byArray = RM.getRMS(3, false);
        int n = RM.getRMSError();
        if (n == 0 && byArray != null) {
            Replay.load(byArray);
            sReplayExist = true;
        } else {
            sReplayExist = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadHighscore() {
        localHighscoreNameTable = new String[6][5];
        localHighscoreScoreTable = new int[6][5];
        byte[] byArray = new byte[3];
        byte[] byArray2 = RM.getRMS(1, false);
        if (RM.getRMSError() != 1) {
            DataInputStream dataInputStream = RM.getDataInput(byArray2);
            try {
                for (int i = 0; i < 6; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        char[] cArray = new char[byArray.length];
                        for (int k = 0; k < byArray.length; ++k) {
                            cArray[k] = dataInputStream.readChar();
                        }
                        Menu.localHighscoreNameTable[i][j] = new String(cArray);
                        Menu.localHighscoreScoreTable[i][j] = dataInputStream.readInt();
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                RM.closeStream(dataInputStream);
            }
        }
    }

    private static final StringBuffer getNameBuffer(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.setLength(n2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (options[i] != 0) {
                stringBuffer.setCharAt(i - n, (char)options[i]);
                continue;
            }
            stringBuffer.setCharAt(i - n, ' ');
        }
        return stringBuffer;
    }

    private static final String getDisplayName(String string, boolean bl) {
        int n = 0;
        StringBuffer stringBuffer = null;
        int n2 = Menu.getInputNameLengthMax();
        if (string != null) {
            stringBuffer = new StringBuffer(n2);
            stringBuffer.setLength(n2);
            int n3 = Math.min(n2, string.length());
            for (int i = 0; i < n3; ++i) {
                char c = string.charAt(i);
                if (c != ' ') {
                    n = i + 1;
                    stringBuffer.setCharAt(i, c);
                    continue;
                }
                stringBuffer.setCharAt(i, ' ');
            }
        }
        if (bl && n == 0 || stringBuffer == null) {
            return "";
        }
        return stringBuffer.toString().trim();
    }

    protected static final void doPause() {
        GCanvas.resetKeys();
        Menu.stopMusic();
        if (!paused) {
            paused = true;
            if (mode != 0 && (mode != 1 || currentMenu != 32)) {
                if (mode == 2 || Menu.getMenuType(currentMenu) != 4) {
                    Menu.userPause(true);
                }
            } else {
                pausedOnSplash = true;
            }
        }
    }

    public static final void userPause(boolean bl) {
        if (mode == 2) {
            if (Game.sModeReplay) {
                if (!bl) {
                    if (Game.sPauseReplay) {
                        Game.correctingTimes(System.currentTimeMillis());
                        Game.sPauseReplay = false;
                        GCanvas.setSoftButton(14, 9, true);
                    } else {
                        Game.sPauseReplay = true;
                        Game.sPauseStartTime = System.currentTimeMillis();
                        GCanvas.setSoftButton(14, 11, true);
                    }
                } else {
                    Game.sPauseStartTime = System.currentTimeMillis();
                    Game.sGameStyle = sTempGameStyle;
                    Avatar.character = sTempCharacter;
                    GameBoard.sStartingFloorStyle = sTempStartingFloorStyle;
                    Keys.sAutoJump = sTempRejumpOption;
                    if (sWatchingLoadedReplay) {
                        Menu.changeMenu(0, false);
                    } else {
                        Menu.changeMenu(18, false);
                    }
                }
            } else if (delayedMenuCountDown > 0) {
                delayedMenuCountDown = -1;
                Menu.changeMenu(delayedMenu, false);
            } else {
                Game.sPauseStartTime = System.currentTimeMillis();
                Menu.changeMenu(9, false);
            }
        }
    }

    private static final int getMaxPos(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = stringBuffer.length();
        for (int i = 0; i < n2 && stringBuffer.charAt(i) != ' '; ++i) {
            ++n;
        }
        return n < n2 ? n : n2 - 1;
    }

    private static final void ttapReset() {
        ttapCountdown = -1;
        ttapChar = '\u0000';
        ttapPos = -1;
        ttapKey = 0;
    }

    private static final StringBuffer getEnterNameBuffer() {
        return connectedUserName;
    }

    private static final void enterNameBack() {
        boolean bl;
        StringBuffer stringBuffer = Menu.getEnterNameBuffer();
        boolean bl2 = bl = stringBuffer.charAt(enterNamePos) == ' ' && enterNamePos > 0;
        if (ttapCountdown >= 0) {
            if (enterNamePos == enterNameMax) {
                Menu.enterNamePos(1);
            }
            Menu.ttapReset();
        }
        int n = stringBuffer.length() - 1;
        if (bl) {
            Menu.enterNamePos(-1);
        }
        for (int i = enterNamePos; i < n; ++i) {
            stringBuffer.setCharAt(i, stringBuffer.charAt(i + 1));
        }
        stringBuffer.setCharAt(n, ' ');
        Menu.enterNamePos(-1);
        if (bl) {
            Menu.enterNamePos(1);
        }
    }

    private static final void enterNamePos(int n) {
        enterNameMax = Menu.getMaxPos(Menu.getEnterNameBuffer());
        enterNamePos = Math.max(0, Math.min(enterNamePos + n, enterNameMax));
    }

    private static final int getMenuItemTop() {
        return Menu.getMenuSeperatorTop() + MENU_SEPERATOR_HEIGHT;
    }

    public static final int getMenuSeperatorTop() {
        int n = MENU_SEPERATOR_TOP + menuCaptionOffset;
        if (menuCaptionImage >= 0) {
            n += RM.getHeight(menuCaptionImage);
            n += 4;
        }
        return n;
    }

    protected static final int getMenuType(int n) {
        return menus[n][1];
    }

    private static final int getMenuCaption(int n) {
        byte by = menus[n][0];
        return by != -1 ? by & 0xFF : -1;
    }

    public static final void menuItemSelected() {
        if (selectedItem >= 0) {
            int n = Menu.getMenuType(currentMenu);
            int n2 = n == 2 ? 0 : selectedItem;
            byte[] byArray = menuItems[currentMenu][n2];
            int n3 = byArray[2] & 0xFF;
            int n4 = byArray[3] & 0xFF;
            Menu.performMenuAction(n3, n4);
        } else {
            Menu.performMenuAction(24);
        }
    }

    private static final void menuItemChanged(int n) {
        if (currentMenu == 15 || currentMenu == -1) {
            int n2 = Menu.getMenuItemCaption(currentMenu, selectedItem);
            byte by = menuItems[currentMenu][selectedItem][3];
            Menu.menuVolumeChanged(n, n2, by);
        }
        Menu.updateMenuItemsWidths(currentMenu);
    }

    private static final void menuVolumeChanged(int n, int n2, int n3) {
        int n4 = options[n3];
        boolean bl = n3 == 0;
        int n5 = 0;
        int n6 = 100;
        int n7 = 25;
        n4 += n * n7;
        Menu.options[n3] = n4 = Math.max(n5, Math.min(n4, n6));
        sound.setVolume(options[0], options[0]);
        if (bl && (currentMenu != 15 || menuCaller[15] != 9)) {
            Menu.playMusic(true);
        }
        Menu.refreshMenu();
    }

    private static final void prepareVolumeText() {
        String string = null;
        int n = options[0];
        if (n == 0) {
            string = RM.t(104) + ">";
        } else if (options[0] == 100) {
            string = "<" + String.valueOf(n) + "%";
        } else if (options[0] > 0) {
            string = "<" + String.valueOf(n) + "%>";
        }
        RM.prepareVarText(4, string);
    }

    private static final void prepareJumpText() {
        if (Keys.sAutoJump == 0) {
            RM.prepareVarText(5, RM.t(103));
        } else {
            RM.prepareVarText(5, RM.t(102));
        }
    }

    public static final void performMenuAction(int n) {
        Menu.performMenuAction(n, -1);
    }

    private static final void prepareSoundSplash() {
        String string = RM.t(103);
        if (options[0] != 0) {
            string = RM.t(102);
        }
        String string2 = String.valueOf(GCanvas.getSecond(10999 - soundSplashTime));
        RM.prepareVarText(26, string, string2);
    }

    private static void prepareHelpString() {
        String[] stringArray = new String[6];
        stringArray[0] = Keys.getKeyString(Keys.sKeys[0]);
        stringArray[1] = Keys.getKeyString(Keys.sKeys[1]);
        stringArray[2] = Keys.getKeyString(Keys.sKeys[4]);
        stringArray[3] = Keys.getKeyString(Keys.sKeys[2]);
        stringArray[4] = Keys.getKeyString(Keys.sKeys[3]);
        String string = RM.t(140);
        int n = RM.getSubstringWidth(string, 0, string.length(), textScreenFont);
        if (n > MENU_TEXT_WIDTH) {
            string = RM.t(139);
        }
        stringArray[5] = string;
        RM.prepareVarText(20, stringArray);
        stringArray = new String[]{RM.t(134), RM.t(133)};
        RM.prepareVarText(21, stringArray);
    }

    public static final void performMenuAction(int n, int n2) {
        switch (n) {
            case 6: {
                Menu.changeMenu(18, true);
                break;
            }
            case 7: {
                if (Game.sModeReplay) {
                    Menu.changeMenu(0, false);
                    break;
                }
                Menu.changeMenu(18, true);
                break;
            }
            case 15: {
                runFirstTime = false;
                Menu.changeMenu(0, false);
                break;
            }
            case 11: {
                Menu.prepareHelpString();
                Menu.changeMenu(1, true);
                break;
            }
            case 26: {
                Menu.changeMenu(n2, true);
                break;
            }
            case 27: {
                runFirstTime = false;
                Menu.changeMenu(n2, false);
                break;
            }
            case 20: {
                Menu.menuItemSelected();
                break;
            }
            case 23: {
                Menu.performMenuAction(24);
                break;
            }
            case 24: {
                if (menuCaller[currentMenu] != 254) {
                    Menu.changeMenu((int)menuCaller[currentMenu], false);
                    break;
                }
                Menu.performMenuAction(25);
                break;
            }
            case 4: {
                sTextBox = new TextBox(null, connectedUserName.toString().trim(), 3, 0);
                sCmdOK = new Command(RM.t(77), 4, 0);
                sCmdBack = new Command(RM.t(38), 2, 0);
                sTextBox.addCommand(sCmdOK);
                sTextBox.addCommand(sCmdBack);
                sTextBox.setCommandListener((CommandListener)instance);
                Display.getDisplay((MIDlet)Midlet.instance).setCurrent((Displayable)sTextBox);
                break;
            }
            case 16: {
                if (Keys.sAutoJump == 0) {
                    Menu.options[16] = 1;
                    Keys.sAutoJump = 1;
                } else {
                    Menu.options[16] = 0;
                    Keys.sAutoJump = 0;
                }
                Menu.saveOptions();
                Menu.prepareJumpText();
                Menu.refreshMenu();
                break;
            }
            case 22: {
                if (Game.sGameStyle == 0) {
                    Menu.changeMenu(17, true);
                } else {
                    Menu.changeMenu(16, true);
                }
                Menu.menuCaller[Menu.currentMenu] = 15;
                break;
            }
            case 1: {
                if (Game.sGameStyle == 0) {
                    Menu.changeMenu(29, true);
                } else {
                    Menu.changeMenu(30, true);
                }
                Menu.menuCaller[Menu.currentMenu] = 15;
                break;
            }
            case 5: {
                GameBoard.sStartingFloorStyle = n2;
                if (Game.sGameStyle == 0) {
                    Menu.options[7] = n2;
                } else {
                    Menu.options[8] = n2;
                }
                Menu.saveOptions();
                Menu.performMenuAction(24);
                break;
            }
            case 28: {
                try {
                    if (n2 == 0) {
                        Game.sGameDifficulty = Game.DIFFICULTY_EASY;
                    } else if (n2 == 1) {
                        Game.sGameDifficulty = Game.DIFFICULTY_HARD;
                    }
                    Game.sModeReplay = false;
                    Game.initGame(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Menu.changeMode(2);
                break;
            }
            case 21: {
                Avatar.character = n2;
                Menu.options[6] = n2;
                Menu.saveOptions();
                Menu.performMenuAction(24);
                break;
            }
            case 12: {
                sDefiningKey = 0;
                RM.prepareVarText(6, RM.t(36));
                Menu.changeMenu(21, true);
                break;
            }
            case 13: {
                sDefiningKey = 1;
                RM.prepareVarText(7, RM.t(36));
                Menu.changeMenu(21, true);
                break;
            }
            case 19: {
                sDefiningKey = 4;
                RM.prepareVarText(10, RM.t(36));
                Menu.changeMenu(21, true);
                break;
            }
            case 17: {
                sDefiningKey = 2;
                RM.prepareVarText(8, RM.t(36));
                Menu.changeMenu(21, true);
                break;
            }
            case 18: {
                sDefiningKey = 3;
                RM.prepareVarText(9, RM.t(36));
                Menu.changeMenu(21, true);
                break;
            }
            case 29: {
                Game.sGameStyle = n2;
                GameBoard.sStartingFloorStyle = n2 == 0 ? options[7] : options[8];
                Menu.options[5] = n2;
                Menu.saveOptions();
                if (runFirstTime) {
                    Menu.performMenuAction(27, 0);
                    break;
                }
                Menu.performMenuAction(24);
                break;
            }
            case 25: {
                GCanvas.setSoftButton(-1, 9, true);
                Menu.changeMode(2);
                break;
            }
            case 46: {
                Menu.startLoading(144);
                RM.deleteAllRecordStores();
                Menu.setInitialOptions(false);
                sReplayExist = false;
                Menu.loadHighscore();
                Menu.stopLoadingRefresh();
                Menu.performMenuAction(24);
                break;
            }
            case 37: {
                Menu.stop();
                break;
            }
            default: {
                if (n == 34) {
                    Menu.stopMusic();
                    sWatchingLoadedReplay = true;
                    sTempGameStyle = Game.sGameStyle;
                    sTempStartingFloorStyle = GameBoard.sStartingFloorStyle;
                    sTempRejumpOption = Keys.sAutoJump;
                    sTempCharacter = Avatar.character;
                    Menu.loadReplay();
                    Game.initReplay();
                    Game.initGame(true);
                    GCanvas.setSoftButton(9, 10, true);
                    Menu.changeMode(2);
                    break;
                }
                if (n == 33) {
                    Menu.stopMusic();
                    sWatchingLoadedReplay = false;
                    sTempGameStyle = Game.sGameStyle;
                    sTempStartingFloorStyle = GameBoard.sStartingFloorStyle;
                    sTempRejumpOption = Keys.sAutoJump;
                    sTempCharacter = Avatar.character;
                    Game.initReplay();
                    Game.initGame(true);
                    GCanvas.setSoftButton(9, 10, true);
                    Menu.changeMode(2);
                    break;
                }
                if (n == 14) {
                    Replay.save();
                    sReplayExist = true;
                    Menu.performMenuAction(27, 0);
                }
                if (n == 45) {
                    RM.setLocale(n2);
                    Menu.startLoading(142);
                    Menu.options[2] = RM.languageIndex;
                    Menu.saveOptions();
                    Menu.onLanguageChanged();
                    Menu.stopLoadingRefresh();
                    if (splashMode >= 15) {
                        Menu.performMenuAction(24);
                        break;
                    }
                    ++splashMode;
                    Menu.changeMode(0);
                    Menu.onInput();
                    break;
                }
                if (n == 62) {
                    if (selectedItem != 0) break;
                    inputTypeName = (inputTypeName + 1) % 3;
                    RM.setString(169, RM.t(170 + inputTypeName));
                    inputType = inputTypeName;
                    Menu.ttapReset();
                    break;
                }
                if (n == 38) {
                    tmpConnectedUserName = connectedUserName.toString();
                    if (Menu.isBufferEmpty(tmpConnectedUserName)) break;
                    Menu.createInputBuffer(tmpConnectedUserName, 19, 3);
                    Menu.saveOptions();
                    if (highScores) {
                        Menu.addLocalHighscoreCandidate(0 + Game.sGameDifficulty * 3);
                    }
                    if (highFloors) {
                        Menu.addLocalHighscoreCandidate(1 + Game.sGameDifficulty * 3);
                    }
                    if (highCombos) {
                        Menu.addLocalHighscoreCandidate(2 + Game.sGameDifficulty * 3);
                    }
                    Menu.changeMenu(18, false);
                    break;
                }
                if (n == 39) {
                    Menu.enterNameBack();
                    if (!Menu.isBufferEmpty(Menu.getEnterNameBuffer().toString())) break;
                    byte[] byArray = menus[currentMenu];
                    GCanvas.setSoftButton(-1, byArray[4], true);
                    break;
                }
                if (n == 44) {
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    String[] stringArray = localHighscoreNameTable[n2];
                    int[] nArray = localHighscoreScoreTable[n2];
                    Menu.prepareHighscoreList(stringArray, nArray);
                    switch (n2) {
                        case 0: 
                        case 3: {
                            RM.prepareVarText(15, RM.t(69));
                            Menu.changeMenu(35, true);
                            break;
                        }
                        case 1: 
                        case 4: {
                            RM.prepareVarText(15, RM.t(70));
                            Menu.changeMenu(35, true);
                            break;
                        }
                        case 2: 
                        case 5: {
                            RM.prepareVarText(15, RM.t(71));
                            Menu.changeMenu(35, true);
                        }
                    }
                    break;
                }
                if (n == 30) {
                    if (options[0] == 0) {
                        Menu.options[0] = 50;
                    }
                    Menu.changeMenu(0, false);
                    Menu.saveOptions();
                    Menu.refreshMenu();
                    break;
                }
                if (n == 31) {
                    Menu.options[0] = 0;
                    Menu.changeMenu(0, false);
                    Menu.saveOptions();
                    Menu.refreshMenu();
                    break;
                }
                if (n == 2) {
                    Menu.shellOutIplay();
                    break;
                }
                if (n == 3) {
                    Menu.shellOutSprint();
                    break;
                }
                Game.performMenuAction(n, n2);
            }
        }
    }

    private static final boolean isBufferEmpty(String string) {
        if (string == null) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == sCmdOK) {
            connectedUserName.delete(0, connectedUserName.length());
            if (sTextBox != null) {
                connectedUserName.append(sTextBox.getString());
            }
            Display.getDisplay((MIDlet)Midlet.instance).setCurrent((Displayable)GCanvas.getCanvas());
        }
        if (command == sCmdBack) {
            Display.getDisplay((MIDlet)Midlet.instance).setCurrent((Displayable)GCanvas.getCanvas());
        }
        sTextBox = null;
        sCmdOK = null;
        sCmdBack = null;
    }

    private static final void shellOutIplay() {
        try {
            Menu.stop();
            MIDP20Proxy.platformRequest(Midlet.instance, exitURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void shellOutSprint() {
    }

    public static final void refreshMenu() {
        if (mode == 1) {
            int n = selectedItem;
            Menu.changeMenu(currentMenu, false);
            boolean bl = true;
            int n2 = Menu.getMenuType(currentMenu);
            if (n2 != 2 && n2 != 5) {
                boolean bl2 = bl = n < menuItems[currentMenu].length && menuItems[currentMenu][n][4] != 0;
            }
            if (bl) {
                Menu.setSelection(currentMenu, n, 0, false);
            }
        }
    }

    private static final int getSplashID(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    private static final void drawSplash(Graphics graphics) {
        int n;
        graphics.setColor(splashMode < 13 ? -1 : -11075584);
        graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        int n2 = 3;
        if (currentSplash >= 0 && currentSplash <= n2) {
            if (currentSplash == 3) {
                Game.drawBackgroundImage();
            }
            if (RM.isLoaded(n = Menu.getSplashID(currentSplash))) {
                GCanvas.drawImage(n, GCanvas.width >> 1, (GCanvas.height >> 1) + 0, 3);
            }
        }
        int n3 = n = (splashMode == 11 || splashMode == 12 || splashMode == 13) && !showLoading ? 1 : 0;
        if (splashMode >= 2 && splashMode <= 5 && n == 0) {
            int n4 = GCanvas.width * 819 >> 10;
            int n5 = GCanvas.height * 16 >> 10;
            int n6 = GCanvas.width * 102 >> 10;
            int n7 = 1000;
            int n8 = GCanvas.height * n7 >> 10;
            int n9 = GCanvas.width * 798 >> 10;
            int n10 = GCanvas.height * 20 >> 10;
            if ((n4 & 1) != 0) {
                --n4;
            }
            if ((n5 & 1) != 0) {
                --n5;
            }
            if ((n9 & 1) != 0) {
                --n9;
            }
            if ((n10 & 1) != 0) {
                --n10;
            }
            if (n4 - n9 < 2) {
                n9 = n4 - 2;
            }
            if (n5 - n10 < 2) {
                n10 = n5 - 2;
            }
            if (n5 < 4) {
                n5 = 4;
                n10 = 2;
            }
            int n11 = n6 + (n4 - n9 >> 1);
            int n12 = n8 + (n5 - n10 >> 1);
            int n13 = (n9 << 10) / progressBarMax;
            int n14 = n13 * progressCurrent >> 10;
            graphics.setColor(-4144960);
            graphics.fillRect(n6, n8, n4, n5);
            graphics.setColor(-864252);
            graphics.fillRect(n11, n12, n14, n10);
        } else if (n != 0) {
            int n15 = GCanvas.getHeight() - GCanvas.FONT_SMALL.getHeight() - 5;
            graphics.setFont(GCanvas.FONT_SMALL);
            String string = RM.t(165);
            int n16 = GCanvas.getWidth() >> 1;
            Menu.drawSplashMessage(graphics, string, n16, n15 += 2, 17);
        }
        ++currentSplashFrame;
    }

    private static void drawSplashMessage(Graphics graphics, String string, int n, int n2, int n3) {
        GL.gfxDrawStringOutlined(graphics, string, n, n2 + 0, n3, -91354, 0);
    }

    private static final void setupLayout() {
        MENU_SEPERATOR_HEIGHT = GCanvas.getSpriteHeight(0) + 3;
        MENU_SEPERATOR_TOP = 2 + GCanvas.FONT_LARGE_HEIGHT + 1 + Math.abs(2);
        if (currentMenu == 0) {
            MENU_SEPERATOR_TOP = RM.getHeight(26);
        }
        if (currentMenu == 16 || currentMenu == 17) {
            MENU_SEPERATOR_TOP += (GCanvas.getSpriteHeight(5) >> 1) + MENU_SEPERATOR_HEIGHT;
        }
        MENU_ITEM_TOP = MENU_SEPERATOR_TOP + MENU_SEPERATOR_HEIGHT;
        MENU_SCROLLTEXT_TOP = MENU_SCROLLTEXT_BOTTOM = GCanvas.height - RM.getHeight(13) - 2 - 1;
        MENU_SEPERATOR_BOTTOM = MENU_ITEM_BOTTOM = MENU_SCROLLTEXT_TOP - MENU_SEPERATOR_HEIGHT;
        MENU_TEXT_WIDTH = GCanvas.width - 8;
    }

    private static final void init() {
        boolean bl;
        Menu.setupLayout();
        menuCaller = new byte[menus.length];
        Menu.menuCaller[0] = 26;
        menuSelection = new byte[menus.length];
        menuItemWidths = new int[24];
        if (forcedLang != null) {
            Menu.stripMenuItem(15, 100);
        }
        if (!soundPresent) {
            Menu.stripMenuItem(15, 4);
        }
        boolean bl2 = bl = exitURL == null;
        if (!bl) {
            // empty if block
        }
        if (bl) {
            Menu.stripMenuItem(0, 23);
        }
        Menu.onLanguageChanged();
        int n = 35;
        int n2 = 5;
        byte[] byArray = menuItems[n][0];
        byte[][] byArray2 = new byte[n2][6];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray3 = byArray2[i];
            System.arraycopy(byArray, 0, byArray3, 0, 6);
        }
        Menu.menuItems[n] = byArray2;
        Menu.initSound();
    }

    private static final void onLanguageChanged() {
        RM.prepareVarText(1, midletInfo[0], midletInfo[2]);
        boolean bl = GCanvas.swapSoftKeys;
        String string = bl ? RM.t(7) : RM.t(6);
        String string2 = bl ? RM.t(6) : RM.t(7);
        RM.prepareVarText(19, new String[]{string, string2});
        exitURL = Game.readMoreGamesUrl();
        Game.onLanguageChanged();
    }

    private static final void stripMenuItem(int n, int n2) {
        byte[][] byArray = menuItems[n];
        int n3 = byArray.length;
        int n4 = -1;
        for (int i = 0; i < n3; ++i) {
            if (Menu.getMenuItemCaption(byArray[i]) != n2) continue;
            n4 = i;
            break;
        }
        if (n4 >= 0) {
            byte[][] byArrayArray = new byte[n3 - 1][];
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                if (i == n4) continue;
                byArrayArray[n5++] = byArray[i];
            }
            Menu.menuItems[n] = byArrayArray;
        }
    }

    private static final void initSound() {
        sound = new Sound();
    }

    public static final void playMusic(boolean bl) {
        Menu.playSound(8, true, bl);
        titleMusicStarted = true;
    }

    public static final void playSound(int n, boolean bl, boolean bl2) {
        if (sound != null) {
            Menu.updateVolume();
            if (n >= 0) {
                sound.play(n, bl, bl2);
            }
        }
    }

    public static final void stopMusic() {
        try {
            if (sound != null) {
                sound.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        titleMusicStarted = false;
    }

    private static final void updateVolume() {
        if (sound != null) {
            sound.setVolume(options[0], options[0]);
        }
    }

    public static final void newHighscoreCandidate(int n, int n2, byte[] byArray, int n3, int n4, byte[] byArray2, int n5, int n6, byte[] byArray3) {
        Menu.options[9] = GameBoard.sMaxFloor[0];
        Menu.options[10] = GameBoard.sMaxFloor[1];
        saveOptions = true;
        highScores = Menu.prepareHighscoreEntry(n, n2, byArray);
        highFloors = Menu.prepareHighscoreEntry(n3, n4, byArray2);
        highCombos = Menu.prepareHighscoreEntry(n5, n6, byArray3);
        if (n2 == 0) {
            highScores = false;
        }
        if (n4 == 0) {
            highFloors = false;
        }
        if (n6 == 0) {
            highCombos = false;
        }
        if (highScores || highFloors || highCombos) {
            Menu.changeMenuDelayed(34);
        } else {
            Menu.changeMenuDelayed(10);
        }
    }

    private static void prepareStringKey() {
        RM.prepareVarText(6, Keys.getKeyString(Keys.sKeys[0]));
        RM.prepareVarText(7, Keys.getKeyString(Keys.sKeys[1]));
        RM.prepareVarText(8, Keys.getKeyString(Keys.sKeys[2]));
        RM.prepareVarText(9, Keys.getKeyString(Keys.sKeys[3]));
        RM.prepareVarText(10, Keys.getKeyString(Keys.sKeys[4]));
    }

    private static final boolean prepareHighscoreEntry(int n, int n2, byte[] byArray) {
        boolean bl = Menu.getHighscoreRanking(n, n2) >= 0;
        switch (n) {
            case 0: 
            case 3: {
                rank1 = Menu.getHighscoreRanking(n, n2);
                if (!bl) break;
                localHighscoreScoresCandidateTable = n;
                localHighscoreScoresCandidateScore = n2;
                localHighscoreScoresCandidateData = byArray;
                break;
            }
            case 1: 
            case 4: {
                rank2 = Menu.getHighscoreRanking(n, n2);
                if (!bl) break;
                localHighscoreFloorsCandidateTable = n;
                localHighscoreFloorsCandidateScore = n2;
                localHighscoreFloorsCandidateData = byArray;
                break;
            }
            case 2: 
            case 5: {
                rank3 = Menu.getHighscoreRanking(n, n2);
                if (!bl) break;
                localHighscoreCombosCandidateTable = n;
                localHighscoreCombosCandidateScore = n2;
                localHighscoreCombosCandidateData = byArray;
                break;
            }
        }
        return bl;
    }

    public static final int getHighscoreRanking(int n, int n2) {
        int n3 = -1;
        int n4 = n2 * 1;
        for (int i = 0; i < 5; ++i) {
            int n5 = localHighscoreScoreTable[n][i] * 1;
            if (n5 != 0 && n5 > n4) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private static final int addLocalHighscoreCandidate(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: 
            case 3: {
                n2 = localHighscoreScoresCandidateTable;
                n3 = localHighscoreScoresCandidateScore;
                n4 = Menu.getHighscoreRanking(n2, n3);
                break;
            }
            case 1: 
            case 4: {
                n2 = localHighscoreFloorsCandidateTable;
                n3 = localHighscoreFloorsCandidateScore;
                n4 = Menu.getHighscoreRanking(n2, n3);
                break;
            }
            case 2: 
            case 5: {
                n2 = localHighscoreCombosCandidateTable;
                n3 = localHighscoreCombosCandidateScore;
                n4 = Menu.getHighscoreRanking(n2, n3);
                break;
            }
        }
        int[] nArray = localHighscoreScoreTable[n2];
        String[] stringArray = localHighscoreNameTable[n2];
        if (n4 >= 0) {
            for (int i = 3; i >= n4; --i) {
                nArray[i + 1] = nArray[i];
                stringArray[i + 1] = stringArray[i];
            }
            nArray[n4] = n3;
            stringArray[n4] = !Menu.isUsernameEmpty() ? connectedUserName.toString() : RM.t(167);
            Menu.saveHighscore();
        }
        return n4;
    }

    private static final boolean prepareHighscoreList(String[] stringArray, int[] nArray) {
        if (stringArray == null || nArray == null) {
            return false;
        }
        if (highscoreListNames == null) {
            highscoreListNames = new String[5];
            highscoreListScores = new String[5];
        }
        int n = nArray.length;
        for (int i = 0; i < 5; ++i) {
            if (i < n && nArray[i] > 0) {
                String string = String.valueOf(nArray[i]);
                int n2 = RM.getTextWidth(string, GCanvas.FONT_MEDIUM);
                RM.fitString(Menu.getDisplayName(stringArray[i], true), i, MENU_TEXT_WIDTH - n2 - 8, GCanvas.FONT_MEDIUM);
                Menu.highscoreListNames[i] = RM.getFittedString(i);
                Menu.highscoreListScores[i] = string;
                continue;
            }
            Menu.highscoreListNames[i] = RM.t(168);
            Menu.highscoreListScores[i] = null;
        }
        return true;
    }

    private static final void drawLoading(Graphics graphics) {
        graphics.setColor(-11075584);
        graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        ++loadingFrame;
        if (scrollText != null) {
            Menu.drawMenuItem(graphics, GCanvas.FONT_SMALL, -1, scrollText, 5, GCanvas.height - GCanvas.FONT_SMALL_HEIGHT - 5, 20);
        }
    }

    private static final byte[][] getMenuItems(int n) {
        return Menu.getMenuType(n) != 2 ? menuItems[n] : textScreenItems;
    }

    private static final int getNumVisibleItems(int n, byte[][] byArray) {
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (!Menu.itemIsVisible(n, byArray, i)) continue;
            ++n2;
        }
        return n2;
    }

    static final boolean itemIsVisible(int n, byte[][] byArray, int n2) {
        boolean bl = byArray[n2][4] != 0;
        return Menu.getMenuType(n) != 1 || bl;
    }

    private static final void drawMenu(Graphics graphics, int n) {
        int n2;
        int n3;
        graphics.setColor(-11075584);
        graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        int n4 = Menu.getMenuType(n);
        byte[] byArray = menus[n];
        byte[][] byArray2 = Menu.getMenuItems(n);
        if (byArray2 == null) {
            return;
        }
        int n5 = byArray2.length;
        Game.drawCustomMenuBackground(n, selectedItem, 4, MENU_SEPERATOR_BOTTOM - 4);
        if (menuCaptionImage >= 0) {
            n3 = Menu.getMenuSeperatorTop() - RM.getHeight(menuCaptionImage) - 4;
            n2 = menuCaptionAlignLeft ? 4 : GCanvas.width - RM.getWidth(menuCaptionImage) - 4;
            graphics.drawImage(RM.getImage(menuCaptionImage), n2, n3, 20);
        }
        graphics.setColor(-12091801);
        graphics.setColor(-13936562);
        n2 = Menu.getMenuCaption(n);
        n3 = 2;
        int n6 = byArray[2];
        if (n6 > 0) {
            n3 += RM.getWidth(n6) + 1;
            Menu.drawIcon(graphics, n6, 2, 2);
        }
        if (n2 != -1) {
            if (scrInfo[0][0] != 0) {
                n3 = GCanvas.width - Menu.updateScrolling(scrInfo[0]);
            }
            Menu.drawMenuItem(graphics, GCanvas.FONT_LARGE, -3355444, RM.t(n2), n3, 2, 20);
        }
        if (n5 > 0) {
            Menu.setMenuItemPosition(currentMenu, true, false);
            n6 = (menuItemEase + 512 >> 10) + menuClipTop;
            GCanvas.pushClip(graphics);
            GCanvas.clipRect(graphics, 4, menuClipTop, MENU_TEXT_WIDTH, menuClipHeight);
            switch (n4) {
                case 6: {
                    Menu.drawSummaryGame(graphics, n6);
                    break;
                }
                case 3: {
                    Menu.drawHighscoreEntername(graphics, n6, connectedUserName, 34, 3);
                    break;
                }
                default: {
                    if (n4 == 5) {
                        Menu.drawHighscore(graphics, n6);
                        break;
                    }
                    if (n == 6) {
                        Menu.drawAbout(graphics, byArray2, n5, n6);
                        break;
                    }
                    if (n == 29 || n == 30) {
                        Menu.drawMenuItemsIconsCentered(graphics, n, byArray2, n5, n6);
                        break;
                    }
                    if (byArray2[0][1] >= 0) {
                        Menu.drawMenuItemsIconsLeft(graphics, n, byArray2, n5, n6);
                        break;
                    }
                    Menu.drawMenuItemsCentered(graphics, n, byArray2, n5, n6);
                }
            }
            GCanvas.popClip(graphics);
            if (sShowUpDownArrows && showUpArrow) {
                GCanvas.drawSprite(0, GCanvas.width >> 1, Menu.getMenuSeperatorTop() + 2, 0);
            }
            if (sShowUpDownArrows && showDownArrow) {
                GCanvas.drawSprite(0, GCanvas.width >> 1, MENU_SEPERATOR_BOTTOM + 2, 1);
            }
        }
    }

    private static final void drawMenuItemsIconsLeft(Graphics graphics, int n, byte[][] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n3;
        int n8 = Menu.getMenuItemHeight(byArray[0]);
        int n9 = n8 - GCanvas.FONT_MEDIUM_HEIGHT >> 1;
        int n10 = Menu.getMenuType(n);
        byte by = byArray[0][1];
        int n11 = Menu.getSpriteFromIcon(by);
        int n12 = GCanvas.getSpriteWidth(n11);
        int n13 = GCanvas.getSpriteHeight(n11);
        int n14 = 0;
        if (n13 < n8) {
            n14 = n8 - n13 >> 1;
        }
        if ((n6 = GCanvas.width - (n5 = Menu.getMaxMenuTextWidth(n10, byArray) - n12 - 4) >> 1) < (n4 = n12 + 8)) {
            n6 = n4;
            n5 = MENU_TEXT_WIDTH - n6;
        }
        int[] nArray = scrInfo[1];
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            if (n10 == 1 && !Menu.itemIsVisible(n, byArray, i)) continue;
            if (n7 > 0) {
                byte[] byArray2 = byArray[i];
                int n15 = Menu.getMenuItemCaption(byArray2);
                boolean bl2 = byArray[i][4] != 0;
                bl = Menu.itemIsVisible(n, byArray, i);
                if (bl) {
                    by = byArray2[1];
                    if (by >= 0) {
                        Menu.drawIcon(graphics, by, n6 - 4, n7 + n14);
                        Menu.drawIconOverlay(graphics, byArray2, n6 - 4, n7 + n14);
                    }
                    int n16 = i == selectedItem ? -1 : -11295068;
                    n16 = bl2 ? n16 : -13883095;
                    int n17 = n6;
                    if (i == selectedItem && nArray[0] != 0) {
                        n17 = GCanvas.width - Menu.updateScrolling(nArray);
                        Menu.drawMenuItem(graphics, GCanvas.FONT_MEDIUM, n16, RM.t(n15), n17, n7 + n9, 20);
                    } else {
                        Menu.drawMenuItem(graphics, GCanvas.FONT_MEDIUM, n16, RM.getFittedString(i), n17, n7 + n9, 20);
                    }
                }
            }
            if (n7 > graphics.getClipY() + graphics.getClipHeight()) break;
            if (!bl) continue;
            n7 += n8;
        }
    }

    private static final void drawMenuItemsCentered(Graphics graphics, int n, byte[][] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = GCanvas.width >> 1;
        n6 += 0;
        int n7 = n3;
        int n8 = Menu.getMenuType(n);
        Font font = n8 != 2 ? GCanvas.FONT_MEDIUM : textScreenFont;
        int n9 = font.getHeight();
        int[] nArray = scrInfo[1];
        boolean bl = true;
        boolean bl2 = false;
        int n10 = -1;
        for (n5 = 0; n5 < n2; ++n5) {
            if (n8 == 1 && !Menu.itemIsVisible(n, byArray, n5)) continue;
            byte[] byArray2 = byArray[n5];
            n4 = byArray[n5][4] != 0 ? 1 : 0;
            bl = Menu.itemIsVisible(n, byArray, n5);
            if (bl) {
                int n11;
                if (n7 > 0 && (n11 = Menu.getMenuItemCaption(byArray2)) != -1) {
                    int n12 = n5 == selectedItem && n8 != 2 && n8 != 5 ? -1 : -11295068;
                    int n13 = n12 = n4 != 0 ? n12 : -13883095;
                    if (n8 != 2) {
                        int n14;
                        boolean bl3;
                        boolean bl4 = bl3 = menuItemWidths[n5] > MENU_TEXT_WIDTH;
                        if (n5 != selectedItem || nArray[0] == 0) {
                            int n15 = RM.getStringWidth(RM.getFittedString(n5), font);
                            n14 = n6 - (n15 >> 1);
                            n12 = Game.menuDrawSelectionBar(graphics, n12, n7, n11);
                            Menu.drawOverlay(graphics, n5, bl3, byArray2, RM.getFittedString(n5), n14, n7, 20);
                            Menu.drawMenuItem(graphics, font, n12, RM.getFittedString(n5), n14, n7, 20);
                        } else {
                            n14 = GCanvas.width - Menu.updateScrolling(nArray);
                            n12 = Game.menuDrawSelectionBar(graphics, n12, n7, n11);
                            Menu.drawOverlay(graphics, n5, bl3, byArray2, RM.t(n11), n14, n7, 20);
                            Menu.drawMenuItem(graphics, font, n12, RM.t(n11), n14, n7, 20);
                        }
                    } else {
                        Game.menuDrawItem(graphics, textScreenFont, n12, RM.dt(n11), n6, n7, 17);
                    }
                }
                n7 += n9;
                n7 += 2;
            }
            if (n7 > menuClipBottom) break;
        }
        if (currentMenu == 16 || currentMenu == 17) {
            n5 = Game.sGameStyle * 3 + selectedItem;
            GCanvas.pushClip();
            n4 = n3 < graphics.getClipY() ? graphics.getClipY() : n3;
            graphics.setClip(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
            GCanvas.drawSprite(5, GCanvas.getWidth() - GCanvas.getSpriteWidth(5) >> 1, n4 - MENU_SEPERATOR_HEIGHT - GCanvas.getSpriteHeight(5), n5);
            GCanvas.popClip();
        }
    }

    private static final int getMaxMenuTextWidth(int n, byte[][] byArray) {
        int n2 = 0;
        int n3 = byArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            if (n == 1 && byArray[i][4] == 0 || (n5 = Menu.getMenuItemCaption(byArray[i])) == -1 || (n4 = RM.getTextWidth(n5, GCanvas.FONT_MEDIUM)) <= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    private static final void setMenuItemPosition(int n) {
        menuItemPosition = Menu.getMenuType(currentMenu) == 1 ? -visibleSelectedItem * n : -selectedItem * n;
        if (menuItemPosition < -menuItemPositionMax) {
            menuItemPosition = -menuItemPositionMax;
        }
        if (menuItemPosition > 0) {
            menuItemPosition = 0;
        }
    }

    private static final void setMenuItemPosition(int n, boolean bl, boolean bl2) {
        int n2;
        showUpArrow = false;
        showDownArrow = false;
        int n3 = Menu.getMenuType(n);
        byte[][] byArray = Menu.getMenuItems(n);
        if (byArray == null) {
            return;
        }
        int n4 = byArray.length;
        if (n == -1) {
            n4 = 5 * textScreenItems.length;
        }
        int n5 = MENU_ITEM_BOTTOM - Menu.getMenuItemTop() - 4;
        int n6 = Menu.getMenuHeight(n);
        int n7 = Menu.getMenuItemHeight(byArray[0]);
        if (n == 29) {
            n2 = GameBoard.sMaxFloor[0] + 1;
            n6 = n2 * n7;
        } else if (n == 30) {
            n2 = GameBoard.sMaxFloor[1] + 1;
            n6 = n2 * n7;
        }
        menuClipTop = Menu.getMenuItemTop() + 2;
        menuClipHeight = MENU_ITEM_BOTTOM - 2 - menuClipTop;
        if (n3 == 2) {
            menuClipTop += 0;
            menuClipHeight -= 0;
        }
        if (n5 >= n6) {
            menuItemPosition = n5 - n6 >> 1;
            menuItemEase = menuItemPosition << 10;
            menuItemPositionMax = n6 - menuClipHeight;
        } else {
            int n8;
            int n9;
            n2 = n3 == 1 ? visibleSelectedItem : selectedItem;
            int n10 = Menu.getMenuItemHeight(byArray[0]);
            int n11 = menuClipHeight;
            int n12 = menuClipHeight / n10;
            menuClipHeight = n12 * n10;
            menuClipTop += (n11 - menuClipHeight) / 2;
            menuItemPositionMax = n6 - menuClipHeight;
            if (n3 == 2 || n3 == 5) {
                if (selectedItem > n4 - n12) {
                    selectedItem = n4 - n12;
                }
                Menu.setMenuItemPosition(n10);
            } else {
                if (bl2) {
                    Menu.setMenuItemPosition(n10);
                }
                n2 = n3 == 1 ? visibleSelectedItem : selectedItem;
                n9 = -menuItemPosition;
                n8 = n9 / n10;
                int n13 = n8 + n12;
                if (n12 > 2) {
                    if (n2 <= n8) {
                        n9 -= n10;
                    }
                    if (n2 >= n13 - 1) {
                        n9 += n10;
                    }
                } else {
                    if (n2 < n8) {
                        n9 -= n10;
                    }
                    if (n2 > n13 - 1) {
                        n9 += n10;
                    }
                }
                if (n9 > menuItemPositionMax) {
                    n9 = menuItemPositionMax;
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                menuItemPosition = -n9;
            }
            menuItemEase = bl ? ((n9 = (menuItemPosition << 10) - menuItemEase) < -3 || n9 > 3 ? (menuItemEase += n9 / 4) : (menuItemEase += n9)) : menuItemPosition << 10;
            boolean bl3 = showUpArrow = menuItemPosition < 0;
            if (selectedItem > 0) {
                n9 = 1;
                for (n8 = 0; n8 < selectedItem; ++n8) {
                    n9 = n9 != 0 && byArray[n8][4] == 0 ? 1 : 0;
                }
                if (n9 != 0) {
                    showUpArrow = false;
                }
            }
            showDownArrow = menuItemPosition > -menuItemPositionMax;
        }
        menuClipBottom = menuClipTop + menuClipHeight;
    }

    private static final void drawMenuItemsIconsCentered(Graphics graphics, int n, byte[][] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        byte by;
        int n7;
        int n8 = n2;
        if (n == 29) {
            n7 = 8;
            n8 = GameBoard.sMaxFloor[0] + 1;
        } else if (n == 30) {
            n7 = 9;
            n8 = GameBoard.sMaxFloor[1] + 1;
        } else {
            by = byArray[0][1];
            n7 = Menu.getSpriteFromIcon(by);
        }
        int n9 = n3;
        int n10 = Menu.getMenuItemHeight(byArray[0]);
        int n11 = RM.getWidth(30);
        int n12 = GCanvas.getSpriteWidth(n7);
        int n13 = RM.getHeight(30);
        int n14 = GCanvas.getSpriteHeight(n7);
        int n15 = 0;
        if (n14 < n10) {
            n15 = n10 - n14 >> 1;
        }
        if ((n6 = GCanvas.width - (n5 = n12 + 8 + n11) >> 1) < (n4 = n12 + 8)) {
            n6 = n4;
            n5 = MENU_TEXT_WIDTH - n6;
        }
        for (int i = 0; i < n8; ++i) {
            if (n9 > 0) {
                if (n == 29 || n == 30) {
                    GCanvas.drawSprite(n7, n6 + n11 + 8, n9 + n15, i);
                } else {
                    byte[] byArray2 = byArray[i];
                    by = byArray2[1];
                    if (by >= 0) {
                        Menu.drawIcon(graphics, by, n6 + n11 + 8, n9 + n15);
                        Menu.drawIconOverlay(graphics, byArray2, n6 + n11 + 8, n9 + n15);
                    }
                }
                if (i == selectedItem) {
                    GCanvas.drawImage(30, n6 + 0, n9 + n15 + (n14 - n13 >> 1) + 0, 0);
                }
            }
            if (n9 > graphics.getClipY() + graphics.getClipHeight()) break;
            n9 += n10;
        }
    }

    private static final void drawAbout(Graphics graphics, byte[][] byArray, int n, int n2) {
        int n3 = -11295068;
        int n4 = GCanvas.width >> 1;
        int n5 = n;
        ++n5;
        int n6 = n2;
        int n7 = Menu.getMenuItemHeight(byArray[0]);
        for (int i = 0; i < n5; ++i) {
            if (n6 > 0) {
                if (i > n5 - 4) {
                    graphics.drawImage(RM.getImage(19), n4, n6 - n7, 17);
                    graphics.drawImage(RM.getImage(20), n4, n6, 17);
                    n6 -= n7;
                } else {
                    byte[] byArray2 = byArray[i];
                    int n8 = Menu.getMenuItemCaption(byArray2);
                    if (n8 != -1) {
                        Game.menuDrawItem(graphics, textScreenFont, n3, RM.dt(n8), n4, n6, 17);
                    }
                }
            }
            if (n6 > graphics.getClipY() + graphics.getClipHeight()) break;
            n6 += n7;
        }
    }

    private static final void drawOverlay(Graphics graphics, int n, boolean bl, byte[] byArray, String string, int n2, int n3, int n4) {
    }

    private static final int updateScrolling(int[] nArray) {
        int n = nArray[1];
        int n2 = n >> 10;
        nArray[4] = nArray[4] - 1;
        if (nArray[4] < 0) {
            int n3 = nArray[2];
            int n4 = nArray[3];
            nArray[1] = n += 1536 * nArray[5];
            if (n >= n3 || n < n4) {
                nArray[5] = nArray[5] * -1;
            }
        }
        return n2;
    }

    private static final void drawIconOverlay(Graphics graphics, byte[] byArray, int n, int n2) {
    }

    private static final void drawHighscore(Graphics graphics, int n) {
        int n2 = n;
        Font font = GCanvas.FONT_MEDIUM;
        String string = RM.t(168);
        for (int i = 0; i < 5; ++i) {
            String string2 = highscoreListNames[i];
            if (string2 == string) {
                Menu.drawMenuItem(graphics, font, -11295068, string2, GCanvas.width >> 1, n2, 17);
            } else {
                Menu.drawMenuItem(graphics, font, -11295068, string2, 8, n2, 20);
                Menu.drawMenuItem(graphics, font, -11295068, highscoreListScores[i], GCanvas.width - 4 + 0, n2, 24);
            }
            n2 += GCanvas.FONT_MEDIUM_HEIGHT;
            n2 += 2;
        }
    }

    public static final void drawMenuItem(Graphics graphics, Font font, int n, String string, int n2, int n3, int n4) {
        graphics.setFont(font);
        graphics.setColor(-16119286);
        graphics.drawString(string, (n2 += 0) + 1, (n3 += 2) + 1, n4);
        graphics.setColor(n);
        graphics.drawString(string, n2, n3, n4);
    }

    private static final void setMenuItemCaption(byte[] byArray, int n) {
        byArray[0] = (byte)n;
    }

    private static final int getMenuItemCaption(byte[] byArray) {
        byte by = byArray[0];
        return by != -1 ? by & 0xFF : -1;
    }

    public static final int getMenuItemAction(int n, int n2) {
        return menuItems[n][n2][2];
    }

    public static final int getMenuItemTarget(int n, int n2) {
        return menuItems[n][n2][3];
    }

    public static final int getMenuItemCaption(int n, int n2) {
        byte by = menuItems[n][n2][0];
        return by != -1 ? by & 0xFF : -1;
    }

    public static String getMidletInfo(int n) {
        if (n < 3) {
            return midletInfo[n];
        }
        return null;
    }

    public static final int getCurrentMenu() {
        return currentMenu;
    }

    private static final int getSpriteFromIcon(int n) {
        return iconBases[icons[n][0]];
    }

    private static final void drawIcon(Graphics graphics, int n, int n2, int n3) {
        GCanvas.drawSprite(iconBases[icons[n][0]], n2, n3, icons[n][1]);
    }

    public static final int getMenuItemHeight(byte[] byArray) {
        int n = Menu.getMenuItemCaption(byArray);
        int n2 = 0;
        byte by = byArray[1];
        if (by >= 0) {
            n2 = GCanvas.getSpriteHeight(Menu.getSpriteFromIcon(by));
            if (n != -1) {
                n2 = Math.max(GCanvas.FONT_MEDIUM_HEIGHT, n2);
            }
        } else {
            n2 = GCanvas.FONT_MEDIUM_HEIGHT;
        }
        return n2 + 2;
    }

    private static final int getMenuHeight(int n) {
        byte[][] byArray = Menu.getMenuItems(n);
        if (byArray != null && byArray.length > 0) {
            int n2 = Menu.getMenuType(n);
            if (n2 != 1) {
                if (n == -1) {
                    return Menu.getMenuItemHeight(byArray[0]) * (5 + textScreenItems.length);
                }
                return Menu.getMenuItemHeight(byArray[0]) * byArray.length;
            }
            int n3 = byArray.length;
            int n4 = Menu.getMenuItemHeight(byArray[0]);
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                if (byArray[i][4] == 0) continue;
                n5 += n4;
            }
            return n5;
        }
        return GCanvas.FONT_MEDIUM_HEIGHT;
    }

    private static final void updateMenuItemsWidths(int n) {
        byte[][] byArray = menuItems[n];
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = byArray[i];
            int n3 = 4;
            byte by = byArray[0][1];
            if (by >= 0) {
                n3 = GCanvas.getSpriteWidth(Menu.getSpriteFromIcon(by)) + 4;
            }
            String string = RM.t(Menu.getMenuItemCaption(byArray2));
            RM.fitString(string, i, MENU_TEXT_WIDTH - n3, GCanvas.FONT_MEDIUM);
            Menu.menuItemWidths[i] = n3 += RM.getTextWidth(string, GCanvas.FONT_MEDIUM);
        }
    }

    public static final boolean processSoftKeys() {
        int n = GCanvas.getSoftkeys();
        if (n != 0) {
            switch (mode) {
                case 2: {
                    if (n == 262144 || n == 524288) {
                        Menu.userPause(false);
                    }
                    if (n != 131072 || !Game.sModeReplay) break;
                    Game.sGameStyle = sTempGameStyle;
                    Avatar.character = sTempCharacter;
                    GameBoard.sStartingFloorStyle = sTempStartingFloorStyle;
                    Keys.sAutoJump = sTempRejumpOption;
                    Menu.changeMenu(currentMenu, false);
                    break;
                }
                case 1: {
                    byte by;
                    int n2 = -1;
                    if (n == 131072 && lskEnabled) {
                        n2 = 3;
                    }
                    if (n == 262144 && rskEnabled) {
                        n2 = 4;
                    }
                    if (n == 524288 && rskEnabled) {
                        n2 = 4;
                        if (Menu.getMenuType(currentMenu) == 2 && menus[currentMenu][n2] < 0) {
                            n2 = 3;
                        }
                    }
                    if (n2 < 0 || (by = menus[currentMenu][n2]) < 0) break;
                    byte by2 = GCanvas.softkeys[by][3];
                    Menu.performMenuAction(by2);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static final void changeMode(int n) {
        GCanvas.resetKeys();
        if (n == 2) {
            Game.correctingTimes(System.currentTimeMillis());
            paused = false;
            if (Game.isTutorialVisible()) {
                Game.setTutorialVisible(false);
            } else {
                Menu.stopMusic();
                Menu.playSound(9, false, true);
            }
            lskEnabled = true;
            rskEnabled = true;
            Menu.notifyGame(true);
        } else if (n == 1) {
            if (mode == 2) {
                if (!Game.isTutorialVisible()) {
                    Menu.stopMusic();
                }
                Menu.notifyGame(false);
            }
        } else if (n == 0) {
            GCanvas.setSoftButton(-1, -1, false);
        }
        GCanvas.hideSoftKeys = n == 2 || n == 0;
        mode = n;
    }

    private static final void notifyGame(boolean bl) {
        Game.notify(bl);
    }

    public static final void changeMenuDelayed(int n) {
        delayedMenu = n;
        delayedMenuCountDown = 30;
    }

    private static final void prepareMessage(String string, String string2, int n, int n2, int n3) {
        RM.setString(181, string);
        RM.setString(182, string2);
        Menu.menus[33][3] = (byte)n;
        Menu.menus[33][4] = (byte)n2;
    }

    private static final void prepareMessage(String string, String string2, int n, int n2, int n3, int n4) {
        RM.setString(181, string);
        RM.setString(182, string2);
        Menu.menus[33][3] = (byte)n;
        Menu.menus[33][4] = (byte)n2;
        Menu.menuItems[33][0][2] = (byte)n4;
    }

    private static final void showMessage(String string, String string2, int n, int n2, int n3) {
        Menu.prepareMessage(string, string2, n, n2, n3);
        Menu.changeMenu(33, n3);
    }

    private static final void showMessage(String string, String string2, int n, int n2, int n3, int n4) {
        Menu.prepareMessage(string, string2, n, n2, n3, n4);
        Menu.changeMenu(33, n3);
    }

    public static final void showMessage(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            Menu.showMessage(RM.t(n), RM.t(n2), n3, n4, 254);
        } else {
            Menu.showMessage(RM.t(n), RM.t(n2), n3, n4, 254, 0);
        }
    }

    protected static final void changeMenu(int n, int n2) {
        Menu.changeMenu(n, false);
        Menu.menuCaller[n] = (byte)n2;
    }

    private static final boolean handleDemoModeMenus(int n) {
        switch (n) {
            case 8: {
                Menu.performMenuAction(28, 0);
                return true;
            }
            case 12: {
                Menu.performMenuAction(26, 13);
                return true;
            }
        }
        return false;
    }

    public static final void changeMenu(int n, boolean bl) {
        if (GL.handsonDemoIsActive() && Menu.handleDemoModeMenus(n)) {
            return;
        }
        GCanvas.resetKeys();
        menuCaptionImage = -1;
        menuCaptionOffset = 0;
        menuCaptionAlignLeft = false;
        if (bl) {
            if (Menu.getMenuType(currentMenu) != 2) {
                Menu.menuSelection[Menu.currentMenu] = (byte)selectedItem;
            }
            if (n != currentMenu) {
                Menu.menuCaller[n] = (byte)currentMenu;
            }
        } else {
            byte by;
            byte bl2 = (byte)(currentMenu != n ? 0 : selectedItem);
            if (menus[currentMenu][1] == 4) {
                by = 0;
            }
            Menu.menuSelection[Menu.currentMenu] = by;
        }
        if (n == 20) {
            Menu.prepareStringKey();
        }
        if (currentMenu == 26) {
            Menu.menuSelection[0] = 0;
        }
        boolean bl2 = n != currentMenu || mode != 1;
        Menu.prepareMenuChange(currentMenu, n);
        if (mode != 1) {
            Menu.changeMode(1);
        }
        boolean bl3 = n == 0;
        textScreenItems = null;
        RM.flushDynamicStrings(0);
        int n2 = Menu.getMenuType(n);
        if (n2 == 2) {
            boolean bl4 = n == 1 || n == 6;
            int n3 = MENU_TEXT_WIDTH;
            Menu.prepareScrollText(n, GCanvas.FONT_MEDIUM, n3, bl4);
        }
        currentMenu = n;
        Menu.setupLayout();
        Menu.updateMenuItemsWidths(n);
        Menu.setSelection(n, menuSelection[n], 0, bl2);
        Menu.setMenuItemPosition(n, false, false);
        if (n == -1) {
            byte[] byArray = menus[n];
            if (!Menu.isBufferEmpty(Menu.getEnterNameBuffer().toString())) {
                GCanvas.setSoftButton(byArray[3], byArray[4], true);
            } else {
                GCanvas.setSoftButton(-1, byArray[4], true);
            }
        }
        Menu.initMenuCaptionScroller(n);
        if (bl3 && !titleMusicStarted) {
            if (!pausedOnSplash) {
                Menu.playMusic(true);
            } else {
                pausedOnSplash = false;
            }
        }
    }

    public static final void setMenuCaptionImage(int n) {
        Menu.setMenuCaptionImage(n, false);
    }

    public static final void setMenuCaptionImage(int n, boolean bl) {
        menuCaptionImage = n;
        menuCaptionAlignLeft = bl;
    }

    private static final void prepareMenuChange(int n, int n2) {
        if (forcedLang == null && n2 == 31 && RM.languageIndex != 5) {
            Menu.menuSelection[31] = (byte)RM.languageIndex;
        }
        if (n2 == 0) {
            RM.prepareVarText(15, RM.t(108));
            String string = RM.t(-1);
            RM.prepareVarText(22, string);
        }
        if (n2 == 18) {
            Menu.menuSelection[18] = 0;
        }
        if (n2 == 9) {
            Menu.menuSelection[9] = 0;
        }
        if (n2 == 29) {
            Menu.menuSelection[29] = (byte)GameBoard.sStartingFloorStyle;
        }
        if (n2 == 30) {
            Menu.menuSelection[30] = (byte)GameBoard.sStartingFloorStyle;
        }
        if (n2 == 21) {
            Menu.menuSelection[21] = (byte)sDefiningKey;
        }
        if (n2 == 11) {
            Menu.menuSelection[11] = (byte)Game.sGameStyle;
        }
        if (n2 == 17) {
            Menu.menuSelection[17] = (byte)Avatar.character;
        }
        if (n2 == 16) {
            Menu.menuSelection[16] = (byte)Avatar.character;
        }
        if (n2 == 15) {
            // empty if block
        }
        int n3 = Menu.getMenuType(n2);
        if (n == 15 && n2 == menuCaller[15]) {
            Menu.saveOptions();
        }
        if (n2 == 15) {
            Menu.prepareVolumeText();
        }
        if (n2 == 15) {
            Menu.prepareJumpText();
        }
        if (community == 0 && n3 == 3) {
            Menu.ttapReset();
            inputType = 0;
            connectedUserName = Menu.getNameBuffer(19, Menu.getInputNameLengthMax());
            if (Menu.isUsernameEmpty() && tmpConnectedUserName != null) {
                connectedUserName = Menu.createInputBuffer(tmpConnectedUserName, -1, Menu.getInputNameLengthMax());
            } else {
                tmpConnectedUserName = connectedUserName.toString();
            }
        }
        byte[][] byArray = menuItems[n2];
        int n4 = byArray.length;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            byte[] byArray2 = byArray[i];
            byte by = byArray2[5];
            int n6 = byArray2[3] & 0xFF;
            boolean bl = Menu.evaluateCondition(by, n6);
            byArray2[4] = (byte)(bl ? 1 : 0);
            n5 += bl ? 1 : 0;
        }
        Game.onPrepareMenuChange(n2, n);
    }

    private static final void saveRMS(int n) {
        RM.saveStore(n);
    }

    public static final void saveOptions() {
        RM.setRMS(0, options);
        Menu.saveRMS(0);
        saveOptions = false;
    }

    public static final void saveReplay(byte[] byArray) {
        RM.setRMS(3, byArray);
        Menu.saveRMS(3);
    }

    public static final int getAvailReplaySpace(int n) {
        return RM.getRMSSizeAvailable(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveHighscore() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n2 = Menu.getInputNameLengthMax();
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray[n] = 32;
        }
        try {
            for (n = 0; n < 6; ++n) {
                for (int i = 0; i < 5; ++i) {
                    int n3;
                    String string = localHighscoreNameTable[n][i];
                    if (string == null) {
                        for (n3 = 0; n3 < n2; ++n3) {
                            dataOutputStream.writeChar(32);
                        }
                    } else {
                        int n4;
                        n3 = string.length();
                        for (n4 = 0; n4 < n3; ++n4) {
                            char c = string.charAt(n4);
                            dataOutputStream.writeChar(c);
                        }
                        for (n4 = n3; n4 < n2; ++n4) {
                            dataOutputStream.writeChar(32);
                        }
                    }
                    dataOutputStream.writeInt(localHighscoreScoreTable[n][i]);
                }
            }
            dataOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            RM.setRMS(1, byArray2);
            Menu.saveRMS(1);
        }
        catch (Exception exception) {
        }
        finally {
            RM.closeStream(dataOutputStream);
        }
    }

    private static final boolean evaluateCondition(int n, int n2) {
        switch (n) {
            case 4: {
                return sReplayExist;
            }
            case 9: {
                return menuCaller[15] == 0 && !GL.handsonDemoIsActive();
            }
            case 3: {
                return localHighscoreScoreTable[n2][0] != 0;
            }
            case 2: {
                return menuCaller[15] == 0;
            }
        }
        return Game.evaluateCondition(n);
    }

    private static final boolean setLocalizedLSKForLanguageSelection(int n, int n2) {
        if (n == 31 && Menu.getMenuItemAction(n, n2) == 45) {
            switch (Menu.getMenuItemTarget(n, n2)) {
                case 0: {
                    RM.setString(27, RM.t(160));
                    RM.setString(39, RM.t(40));
                    return true;
                }
                case 3: {
                    RM.setString(27, RM.t(162));
                    RM.setString(39, RM.t(42));
                    return true;
                }
                case 1: {
                    RM.setString(27, RM.t(161));
                    RM.setString(39, RM.t(41));
                    return true;
                }
                case 4: {
                    RM.setString(27, RM.t(164));
                    RM.setString(39, RM.t(44));
                    return true;
                }
                case 2: {
                    RM.setString(27, RM.t(163));
                    RM.setString(39, RM.t(43));
                    return true;
                }
            }
        }
        return false;
    }

    public static final void setSoftkeys(int n, int n2, int n3) {
        byte[] byArray = menus[n];
        byArray[3] = (byte)n2;
        byArray[4] = (byte)n3;
    }

    private static final void setSelection(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        boolean bl2;
        int n6;
        byte[][] byArray = menuItems[n];
        int n7 = -1;
        int n8 = Menu.getMenuType(n);
        if (!bl) {
            n7 = selectedItem;
        } else if (n8 == 1) {
            visibleSelectedItem = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                if (!Menu.itemIsVisible(n, byArray, n6)) continue;
                ++visibleSelectedItem;
            }
        }
        if (n8 == 2) {
            byArray = textScreenItems;
        }
        n6 = byArray.length;
        if (n == 29) {
            n6 = GameBoard.sMaxFloor[0] + 1;
        } else if (n == 30) {
            n6 = GameBoard.sMaxFloor[1] + 1;
        }
        boolean bl3 = bl2 = n8 != 2 && n8 != 5 && n8 != 3 && (n2 < 0 || n2 >= n6);
        if (bl2) {
            if (n2 < 0) {
                n2 = n6 - 1;
            }
            if (n2 >= n6) {
                n2 = 0;
            }
        } else {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= n6) {
                n2 = n6 - 1;
            }
        }
        if (n8 == 1) {
            n5 = Menu.getNumVisibleItems(n, byArray);
            n4 = visibleSelectedItem + n3;
            if (n4 < 0) {
                n4 = n5 - 1;
            }
            if (n4 >= n5) {
                n4 = 0;
            }
            visibleSelectedItem = n4;
        }
        if (n8 != 2 && n2 >= 0) {
            while (byArray[n2][4] == 0) {
                if (n3 == 0) {
                    n3 = 1;
                }
                if ((n2 += n3) < 0) {
                    if (bl) {
                        n2 = 0;
                        n3 = -n3;
                    } else {
                        n2 = n7;
                        break;
                    }
                }
                if (n2 < n6) continue;
                if (bl) {
                    n2 = 0;
                    n3 = -n3;
                    continue;
                }
                n2 = n7;
                break;
            }
        }
        selectedItem = n2;
        if (bl2 || bl) {
            Menu.setMenuItemPosition(n, false, true);
        }
        lskEnabled = true;
        rskEnabled = true;
        switch (n) {
            default: 
        }
        if ((n == 15 || n == -1) && (n5 = menuItems[n][selectedItem][2]) == 47) {
            lskEnabled = false;
        } else if (n == 31 && menuCaller[n] != 15) {
            rskEnabled = false;
        }
        byte[] byArray2 = menus[n];
        n4 = lskEnabled ? byArray2[3] : -1;
        int n9 = rskEnabled ? byArray2[4] : -1;
        boolean bl4 = Menu.setLocalizedLSKForLanguageSelection(n, selectedItem);
        GCanvas.setSoftButton(n4, n9, true);
        Menu.initMenuScroller(n);
        if (n8 == 3) {
            inputType = selectedItem == 0 ? inputTypeName : 2;
            RM.setString(169, RM.t(170 + inputType));
            Menu.ttapReset();
            enterNamePos = 0;
            enterNameMax = Menu.getMaxPos(Menu.getEnterNameBuffer());
        }
    }

    private static final void initMenuCaptionScroller(int n) {
        int n2 = Menu.getMenuCaption(n);
        if (n2 != -1) {
            int n3 = 2;
            int n4 = menus[n][2];
            if (n4 >= 0) {
                n3 += RM.getWidth(n4) + 1;
            }
            n4 = RM.getTextWidth(n2, GCanvas.FONT_LARGE);
            Menu.setMenuScrollData(scrInfo[0], n4, n3);
        } else {
            Menu.scrInfo[0][0] = 0;
        }
    }

    private static final void initMenuScroller(int n) {
        if (Menu.getMenuType(n) != 2) {
            int n2 = 4;
            byte by = menuItems[n][0][1];
            if (by >= 0) {
                n2 += GCanvas.getSpriteWidth(Menu.getSpriteFromIcon(by));
            }
            Menu.setMenuScrollData(scrInfo[1], menuItemWidths[selectedItem], n2);
        } else {
            Menu.scrInfo[1][0] = 0;
        }
    }

    private static final void setMenuScrollData(int[] nArray, int n, int n2) {
        nArray[0] = 0;
        if (n > MENU_TEXT_WIDTH) {
            int n3 = 2;
            nArray[0] = 1;
            nArray[2] = n + n3 + 8 - n2 << 10;
            nArray[3] = GCanvas.width - 4 - n2 << 10;
            nArray[4] = 20;
            nArray[1] = nArray[3];
            nArray[5] = 1;
        }
    }

    public static final void startLoading(int n) {
        showLoading = true;
        scrollText = RM.t(n);
        GCanvas.setSoftButton(-1, -1, true);
        GCanvas.hideSoftKeys = true;
        loadingFrame = 0;
        if (mode == 2) {
            Menu.notifyGame(false);
        }
        GCanvas.redraw();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void stopLoadingRefresh() {
        showLoading = false;
        GCanvas.resetKeys();
        boolean bl = GCanvas.hideSoftKeys = mode == 2;
        if (mode == 2) {
            Menu.notifyGame(true);
        } else {
            Menu.refreshMenu();
        }
    }

    public static final void stopLoading() {
        showLoading = false;
        GCanvas.hideSoftKeys = mode == 2;
        GCanvas.resetKeys();
        if (mode == 2) {
            Menu.notifyGame(true);
        }
    }

    private static final int nextBreak(int n, String string, Font font, int n2) {
        int n3 = n;
        int n4 = string.length();
        if (n >= n4) {
            return -1;
        }
        int n5 = n;
        while (true) {
            int n6;
            if (n3 < n4) {
                if (string.charAt(n3) > ' ') {
                    ++n3;
                    continue;
                }
                if (n3 < n4 - 1 && ((n6 = (int)string.charAt(n3 + 1)) == 33 || n6 == 63 || n6 == 58)) {
                    n3 += 2;
                    continue;
                }
            }
            n6 = RM.getSubstringWidth(string, n5, n3 - n5, font);
            if (n == n5 && n6 > n2) {
                while (RM.getSubstringWidth(string, n5, --n3 - n5, font) > n2) {
                }
                n = n3;
                break;
            }
            if (n6 <= n2) {
                n = n3;
            }
            if (n6 > n2 || n3 >= n4 || string.charAt(n3) == '\n') break;
            ++n3;
        }
        return n >= n4 ? n : ++n;
    }

    private static final void prepareScrollText(int n, Font font, int n2, boolean bl) {
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        if (bl) {
            Menu.startLoading(142);
        }
        textScreenFont = font;
        Vector<Object> vector = new Vector<Object>();
        byte[][] byArray = menuItems[n];
        int n7 = byArray.length;
        int n8 = 0;
        for (int i = 0; i < n7; ++i) {
            n6 = 0;
            String string = RM.t(Menu.getMenuItemCaption(byArray[i]));
            while (n6 >= 0 && (n5 = Menu.nextBreak(n6, string, font, n2)) >= 0) {
                object = string.substring(n6, n5).trim();
                int n9 = ((String)object).length();
                if (n9 > 0 || n8 > 0) {
                    vector.addElement(object);
                }
                n8 = n9;
                n6 = n5;
            }
            if (n8 <= 0) continue;
            vector.addElement("");
            n8 = 0;
        }
        byte[] byArray2 = menuItems[n][0];
        n6 = byArray2.length;
        int n10 = vector.size();
        for (n5 = n10 - 1; n5 >= 0; --n5) {
            object = (String)vector.elementAt(n5);
            if (((String)object).length() <= 0) continue;
            n10 = n5 + 1;
            break;
        }
        n5 = 0;
        if (n == 6) {
            n5 += 4;
        }
        object = new byte[n10 + n5][n6];
        RM.flushDynamicStrings(n10 + n5);
        for (n4 = 0; n4 < n10; ++n4) {
            Object object2 = object[n4];
            System.arraycopy(byArray2, 0, object2, 0, n6);
            n3 = RM.createDynamicString((String)vector.elementAt(n4));
            Menu.setMenuItemCaption((byte[])object2, n3);
        }
        if (n == 6) {
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = RM.createDynamicString(" ");
                Menu.setMenuItemCaption((byte[])object[n10 + n4], n3);
            }
        }
        textScreenItems = (byte[][])object;
        if (bl) {
            Menu.stopLoading();
        }
    }

    protected static final void onLoadingStart(int n) {
        progressBarMax = n;
        GCanvas.redraw();
    }

    protected static final void onLoadingStep(int n) {
        progressCurrent = n;
        if (RM.getCurrentLoading() > Menu.getSplashID(0) && currentSplash < 0) {
            Menu.startSplash(0, 2000);
        }
        if ((n & 0x1F) == 0) {
            GCanvas.redraw();
        }
        GCanvas.idleTick();
    }

    protected static final void onLoadingDone() {
        Menu.advanceSplashMode();
    }

    protected static final void loadJadParams() {
        Menu.midletInfo[0] = Menu.readJad("MIDlet-Name") + "";
        Menu.midletInfo[1] = Menu.readJad("MIDlet-Vendor") + "";
        Menu.midletInfo[2] = Menu.readJad("MIDlet-Version") + "";
        int n = GL.handsonEstablishLanguageSetup();
        forcedLang = n != -1 ? GL.HANDSON_LANGUAGE_CODES[n] : null;
        n = GCanvas.width;
        int n2 = GCanvas.height;
        exitURL = Game.readMoreGamesUrl();
        soundDefault = Menu.readJadInt("SOUNDDEFAULTOFF", 1) == 0;
        soundPresent = Menu.readJadInt("SOUNDNOTPRESENT", 0) == 0;
        int n3 = Menu.readJadInt("FORCEDSCREENWIDTH", n);
        int n4 = Menu.readJadInt("FORCEDSCREENHEIGHT", n2);
        GCanvas.setForcedSize(n3, n4);
        GCanvas.swapSoftKeys = Menu.readJadInt("SOFTKEYSWAP", 0) != 0;
    }

    public static final String readJad(String string) {
        String string2 = Midlet.instance.getAppProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static final int readJadInt(String string, int n) {
        int n2;
        block4: {
            String string2 = Menu.readJad(string);
            n2 = n;
            if (string2 != null) {
                try {
                    int n3;
                    n2 = n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.equals("Y")) {
                        n2 = 1;
                    }
                    if (!string2.equals("N")) break block4;
                    n2 = 0;
                }
            }
        }
        return n2;
    }

    public static int getMode() {
        return mode;
    }

    public static void setMenuOption(int n, int n2, byte by) {
        Menu.menus[n][n2] = by;
    }

    public static void showUpDownArrows(boolean bl) {
        sShowUpDownArrows = bl;
    }

    static {
        sWatchingLoadedReplay = false;
        midletInfo = new String[3];
        currentSplash = -1;
        currentMenu = 6;
        inputTypeName = inputType = 0;
        scrInfo = new int[2][6];
        titleMusicStarted = false;
        soundSplashTimeHelper = -1;
        uploadingPrevHighscore = false;
        tryToUploadPrevHighscore = true;
        textScreenFont = GCanvas.FONT_MEDIUM;
        ttap = new char[][]{{'0'}, {'_', '1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}};
        progressBarMax = 78;
        sOptionsNeedReset = false;
        sShowUpDownArrows = true;
    }
}

