/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Avatar;
import game.Bubbles;
import game.Clock;
import game.Combo;
import game.Floor;
import game.Game;
import game.Particles;
import game.RandomGenerator;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tinbrain.GCanvas;
import tinbrain.RM;

public class GameBoard {
    private static int sNoOfGeneratedFloors;
    public static int sFloorsGap;
    public static int sYStartPosition;
    public static int sFloorsHeight;
    private static int sFloorsStyle;
    private static int sScore;
    private static int sScoreFromCombos;
    private static int sOverallScore;
    private static int sWhenChangingStyle;
    private static int sWhenDrawingLongFloor;
    public static int sScrollSpeed;
    private static boolean sMaxSpeed;
    public static int sStartingFloorStyle;
    public static int[] sMaxFloor;
    private static int sTileSize;
    private static int sWallPosOffset;
    private static int sBackdropPosOffset;
    private static int sTilePosOffset;
    private static Floor[] sItemsArray;
    private static int sStartItemsIdx;
    private static Image sWallLeftImage;
    private static Image sWallRightImage;
    private static Image sBackdropImage;
    private static int sWallWidth;
    private static int sBackdropWidth;
    private static Floor sPrevFloor;
    private static byte[] sFloorWidthIdLimits;
    private static int sGraduationNumber;
    private static int sGraduationOverlappingNumber;
    public static int sAvatarBubbleOffsetY;
    public static int lastWallSpeed;
    public static int lastBackdropSpeed;
    public static int lastFloorSpeed;

    public static final void init() {
        sFloorsHeight = GCanvas.getSpriteHeight(RM.getValue(71, Game.sGameStyle, 0));
        sFloorsGap = RM.getValue(76, Game.sGameStyle, 0);
        sAvatarBubbleOffsetY = RM.getValue(76, Game.sGameStyle, 9);
        sYStartPosition = Game.sGameHeight - sFloorsHeight;
        sWhenChangingStyle = RM.getValue(76, Game.sGameStyle, 3);
        sWhenDrawingLongFloor = RM.getValue(76, Game.sGameStyle, 4);
        sTileSize = 48;
        if (Game.sGameStyle == 0) {
            sWallLeftImage = RM.getImage(45);
            sWallWidth = sWallLeftImage.getWidth();
            sWallRightImage = RM.getImage(46);
            sBackdropImage = RM.getImage(47);
            sBackdropWidth = sBackdropImage.getWidth();
        } else {
            sWallLeftImage = RM.getImage(57);
            sWallWidth = sWallLeftImage.getWidth();
            sWallRightImage = RM.getImage(58);
            sBackdropImage = RM.getImage(59);
            sBackdropWidth = sBackdropImage.getWidth();
        }
        int n = 48 * (Game.sGameHeight / 48 + 2);
        sItemsArray = new Floor[n / 48];
    }

    public static final void restart() {
        sYStartPosition = Game.sGameHeight - sFloorsHeight;
        sMaxSpeed = false;
        sFloorsStyle = sStartingFloorStyle;
        sScore = 0;
        sScrollSpeed = 0;
        sScoreFromCombos = 0;
        sNoOfGeneratedFloors = 0;
        sOverallScore = 0;
        GameBoard.initFloorWidthLimits();
        sStartItemsIdx = sItemsArray.length - 1;
        sTilePosOffset = 0;
        sWallPosOffset = 0;
        sBackdropPosOffset = 0;
        for (int i = sItemsArray.length - 1; i >= 0; --i) {
            Floor floor;
            GameBoard.sItemsArray[GameBoard.sStartItemsIdx] = floor = GameBoard.addFloor(sStartItemsIdx, sItemsArray[sStartItemsIdx]);
            if (--sStartItemsIdx >= 0) continue;
            sStartItemsIdx += sItemsArray.length;
        }
    }

    public static final int getWallWidth() {
        return sWallWidth;
    }

    public static final int getFloorsHeight() {
        return sFloorsHeight;
    }

    public static final int getFirstFloorYPos() {
        return sYStartPosition;
    }

    public static final int getFloorsGap() {
        return sFloorsGap;
    }

    private static final Floor generateFloor(int n, int n2, Floor floor) {
        int n3;
        boolean bl = true;
        boolean bl2 = false;
        if (n % sWhenDrawingLongFloor == 0 || n == 0) {
            n3 = 3;
            bl = false;
            bl2 = true;
        } else {
            n3 = GameBoard.randomFloorsWidth();
            n3 = GameBoard.checkFloorWidthLimits(n3, n);
            bl2 = false;
        }
        int n4 = GCanvas.getSpriteFrames(RM.getValue(71, Game.sGameStyle, 0));
        if (n2 < n4) {
            if (floor == null) {
                floor = new Floor(n3, n2, n, bl2);
            } else {
                floor.reinitFloor(n3, n2, n, bl2);
            }
        } else if (floor == null) {
            floor = new Floor(n3, n4 - 1, n, bl2);
        } else {
            floor.reinitFloor(n3, n4 - 1, n, bl2);
        }
        if (bl) {
            GameBoard.checkPlatformOverlapping(floor, n);
        }
        return floor;
    }

    private static final void initFloorWidthLimits() {
        GameBoard.sFloorWidthIdLimits[0] = 0;
        GameBoard.sFloorWidthIdLimits[1] = 0;
        sGraduationNumber = 0;
        sPrevFloor = null;
        sGraduationOverlappingNumber = 0;
    }

    private static final int checkFloorWidthLimits(int n, int n2) {
        int n3;
        if (n > 1 || Game.sGameDifficulty == Game.DIFFICULTY_HARD) {
            return n;
        }
        int n4 = RM.getHeight(79);
        boolean bl = false;
        for (n3 = sGraduationNumber; n3 < n4; ++n3) {
            int n5 = RM.getValue(79, n3, 2);
            if (n2 > n5) continue;
            bl = true;
            if (sGraduationNumber == n3) break;
            sGraduationNumber = n3;
            GameBoard.sFloorWidthIdLimits[0] = 0;
            GameBoard.sFloorWidthIdLimits[1] = 0;
            break;
        }
        if (!bl) {
            return n;
        }
        n3 = RM.getValue(79, sGraduationNumber, n);
        if (n3 == -1) {
            return n;
        }
        if (sFloorWidthIdLimits[n] + 1 <= n3) {
            int n6 = n;
            sFloorWidthIdLimits[n6] = (byte)(sFloorWidthIdLimits[n6] + 1);
        } else if (n == 0 && sFloorWidthIdLimits[n + 1] + 1 <= RM.getValue(79, sGraduationNumber, n + 1)) {
            int n7 = n + 1;
            sFloorWidthIdLimits[n7] = (byte)(sFloorWidthIdLimits[n7] + 1);
            ++n;
        } else {
            n = 2;
        }
        return n;
    }

    private static final void checkPlatformOverlapping(Floor floor, int n) {
        int n2;
        if (Game.sGameDifficulty == Game.DIFFICULTY_HARD) {
            return;
        }
        int n3 = RM.getHeight(80);
        boolean bl = false;
        for (n2 = sGraduationOverlappingNumber; n2 < n3; ++n2) {
            int n4 = RM.getValue(80, n2, 1);
            if (n > n4) continue;
            bl = true;
            if (sGraduationOverlappingNumber == n2) break;
            sGraduationOverlappingNumber = n2;
            break;
        }
        if (!bl) {
            return;
        }
        if (sPrevFloor != null) {
            n2 = RM.getValue(80, sGraduationOverlappingNumber, 0);
            floor.reCalcXPosition(sPrevFloor, n2);
        }
        sPrevFloor = floor;
    }

    private static final int randomFloorsWidth() {
        return RandomGenerator.nextInt() % RM.getValue(76, Game.sGameStyle, 8);
    }

    public static final int setScrollSpeed(long l, boolean bl) {
        int n;
        if (!sMaxSpeed) {
            long l2 = Game.sAllFrameTime;
            if (!Game.sModeReplay && l2 > (long)(RM.getValue(75, Game.sGameDifficulty, sScrollSpeed) * 1000)) {
                if (sScrollSpeed < 7) {
                    if (sScrollSpeed > 0) {
                        Clock.displayMessage();
                    }
                    ++sScrollSpeed;
                } else {
                    sMaxSpeed = true;
                }
            }
        }
        if (bl) {
            if (Avatar.getPosY() < 0) {
                if (Avatar.sJumpSpeed > 0) {
                    return Math.max(Avatar.sJumpSpeed, 7);
                }
                return 6;
            }
            if (Avatar.getPosY() < 20) {
                if (Avatar.sJumpSpeed > 0) {
                    return Math.min(Avatar.sJumpSpeed, 5);
                }
                return 5;
            }
            if (Avatar.getPosY() < Game.sGameHeight / 4) {
                if (Avatar.sJumpSpeed > 0) {
                    return Math.min(Avatar.sJumpSpeed, 4);
                }
                return 4;
            }
        }
        if ((n = RM.getValue(74, sScrollSpeed) + Game.sCheatScrollSpeed) > 0) {
            return n;
        }
        return 0;
    }

    public static final void update(long l, boolean bl) {
        int n;
        int n2;
        int n3;
        lastFloorSpeed = n3 = GameBoard.setScrollSpeed(l, bl);
        sYStartPosition += n3;
        if (Game.sFastScroll) {
            n2 = n3 - 1;
            n = n3 + 1;
        } else {
            n2 = RM.getValue(74, sScrollSpeed) - 1;
            n = RM.getValue(74, sScrollSpeed) + 1;
        }
        if (n2 < 1) {
            n2 = Game.frameCount % 2 == 0 ? 1 : 0;
        }
        if ((sWallPosOffset += n) >= sWallLeftImage.getHeight()) {
            sWallPosOffset %= sWallLeftImage.getHeight();
        }
        if ((sBackdropPosOffset += n2) >= sBackdropImage.getHeight()) {
            sBackdropPosOffset %= sBackdropImage.getHeight();
        }
        lastWallSpeed = n;
        lastBackdropSpeed = n2;
        for (int i = 0; i < sItemsArray.length; ++i) {
            int n4;
            Floor floor = sItemsArray[i];
            if (floor.getFloorLong() || floor.getDestroyed() || !floor.getTouched() || (n4 = floor.getFloorTouchedPosY()) <= 0) continue;
            floor.setFloorTouchedPosY(n4 + lastFloorSpeed);
        }
        if (sTilePosOffset < sTileSize && sTilePosOffset + n3 >= sTileSize) {
            Floor floor;
            sTilePosOffset += n3;
            sTilePosOffset %= sTileSize;
            GameBoard.sItemsArray[GameBoard.sStartItemsIdx] = floor = GameBoard.addFloor(sStartItemsIdx, sItemsArray[sStartItemsIdx]);
            if (--sStartItemsIdx < 0) {
                sStartItemsIdx += sItemsArray.length;
            }
        } else {
            sTilePosOffset += n3;
        }
    }

    public static final void updateMovingPlatforms() {
        for (int i = 0; i < sItemsArray.length; ++i) {
            int n;
            Floor floor = sItemsArray[i];
            if (floor.getFloorLong() || floor.getFloorBrick() || (n = sYStartPosition - floor.getFloorIndex() * sTileSize) + sFloorsHeight < 0 || n > Game.sGameHeight) continue;
            int n2 = floor.getXPosFixed();
            n2 += floor.getMovingPlatformSign() * Game.sMovingPlatofrmsSpeed;
            n2 = floor.checkXPosBoundingFixed(n2);
            if (!Game.sPowerUpNailsActive) {
                floor.setXPosFixed(n2);
            }
            if (!floor.isLeftSideStick() && !floor.isRightSideStick()) continue;
            floor.changeMovingSign();
        }
    }

    public static final void updateDestPlatformsTimers(long l) {
        for (int i = 0; i < sItemsArray.length; ++i) {
            Floor floor = sItemsArray[i];
            if (floor.getFloorTable() || floor.getFloorBrick() || floor.getFloorLong() || floor.getDestroyed() || !floor.getTouched()) continue;
            floor.setTouchTime(floor.getTouchTime() + l);
        }
    }

    public static final void updateDestPlatforms() {
        for (int i = 0; i < sItemsArray.length; ++i) {
            Floor floor = sItemsArray[i];
            long l = System.currentTimeMillis();
            if (!(floor.getFloorTable() || floor.getFloorBrick() || floor.getFloorLong() || floor.getDestroyed() || !floor.getTouched() || floor.getTouchTime() + 2500L >= l)) {
                floor.setDestroyed(true);
                int n = floor.getFloorTouchedPosY();
                int n2 = floor.getXPos();
                int n3 = floor.getFloorType();
                int n4 = floor.getFloorWidth();
                Particles.initEffectByFloorStyle(n2, n, n4, n3);
            }
            if (floor.getFloorTable() || floor.getFloorBrick() || floor.getFloorLong() || floor.getDestroyed() || !floor.getTouched()) continue;
            if (floor.getTouchTime() + 1250L < l) {
                floor.calcDestPlatformsShake(false);
            }
            if (floor.getTouchTime() + 2500L - 312L >= l) continue;
            floor.calcDestPlatformsShake(true);
        }
    }

    public static final void updatePowerUpCollision() {
        Floor floor = GameBoard.getFloor(Game.sCurrentFloor);
        if (floor == null) {
            return;
        }
        if (!floor.getFloorPowerUp()) {
            return;
        }
        int n = 0;
        if (floor != null) {
            n = floor.getFloorIndex();
        }
        int n2 = GameBoard.getFirstFloorYPos() - n * (GameBoard.getFloorsHeight() + GameBoard.getFloorsGap());
        int n3 = GCanvas.getSpriteWidth(23);
        int n4 = GCanvas.getSpriteHeight(23);
        int n5 = floor.getXPos() + (floor.getFloorWidth() - n3 >> 1);
        int n6 = n5 + n3;
        int n7 = Avatar.getPosX() + Avatar.getAvatarXPosCorrection();
        int n8 = n7 + Avatar.getAvatarWidth();
        int n9 = n2;
        int n10 = n9 - n4;
        int n11 = Avatar.getPosY();
        int n12 = n11 + Avatar.getAvatarHeight();
        int n13 = floor.getFloorIndex();
        if (n7 < n6 && n8 > n5 && n11 < n9 && n12 > n10) {
            floor.setFloorPowerUp(false);
            int n14 = floor.getFloorPowerUpIdx();
            if (n14 == 1) {
                if (Game.sPowerUpBrickActive) {
                    Particles.initEffectByPowerUpIdx(n5, n10, n3, n14);
                }
            } else {
                Particles.initEffectByPowerUpIdx(n5, n10, n3, n14);
            }
            switch (n14) {
                case 0: {
                    if (!Game.sPowerUpNailsActive) {
                        Game.sPowerUpNailsIntroTimer = System.currentTimeMillis();
                        Game.sPowerUpNailsActive = true;
                    }
                    Game.sPowerUpNailsOutroTimer = 0L;
                    Game.sPowerUpNailsOutroActive = false;
                    Game.sPowerUpNailsTimer = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    if (!Game.sPowerUpBubbleActive) {
                        Bubbles.initEffect();
                    } else {
                        Bubbles.continueEffect();
                    }
                    Game.sPowerUpBubbleActive = true;
                    Avatar.switchGravityWater();
                    Game.sPowerUpBubbleTimer = System.currentTimeMillis();
                    break;
                }
                case 1: {
                    if (!Game.sPowerUpBrickActive) {
                        boolean bl = false;
                        for (int i = 0; i < sItemsArray.length; ++i) {
                            Floor floor2 = sItemsArray[i];
                            int n15 = floor2.getFloorIndex();
                            if (n15 < n13) continue;
                            floor2.setFloorBrickOn();
                            int n16 = sYStartPosition - floor2.getFloorIndex() * sTileSize;
                            int n17 = floor2.getXPos();
                            int n18 = floor2.getFloorType();
                            int n19 = floor2.getFloorWidth();
                            Particles.initEffectByBrick(n17, n16, n19, n18);
                        }
                    }
                    Game.sPowerUpBrickActive = true;
                    Game.sPowerUpBrickTimer = System.currentTimeMillis();
                }
            }
        }
    }

    private static final Floor addFloor(int n, Floor floor) {
        floor = GameBoard.generateFloor(sNoOfGeneratedFloors, sFloorsStyle, floor);
        if (++sNoOfGeneratedFloors % sWhenChangingStyle == 0) {
            ++sFloorsStyle;
        }
        int n2 = n * sTileSize;
        return floor;
    }

    public static final void addComboScore(int n) {
        if (Combo.sAddScoreFromCombo) {
            sScoreFromCombos += n;
            Combo.sAddScoreFromCombo = false;
        }
    }

    public static final void calculateScore(int n) {
        if (!Avatar.isFalling() && !Avatar.isJumping()) {
            sScore = n * 10;
            Game.sMaxFloors = n;
        }
        sOverallScore = sScore + sScoreFromCombos;
    }

    public static final int getScore() {
        return sOverallScore;
    }

    public static final Floor getFloor(int n) {
        for (int i = sItemsArray.length - 1; i >= 0; --i) {
            int n2 = sItemsArray[i].getFloorIndex();
            if (n2 != n) continue;
            return sItemsArray[i];
        }
        return null;
    }

    public static final int getCurrentFloor(int n) {
        int n2 = -1;
        int n3 = sStartItemsIdx;
        int n4 = sItemsArray.length - 1;
        while (n4 >= 0) {
            int n5;
            int n6;
            int n7 = n3;
            if (n7 < 0) {
                n7 += sItemsArray.length;
            }
            if ((n6 = sYStartPosition - (n5 = sItemsArray[n7].getFloorIndex()) * sTileSize) < n + Avatar.sAvatarHeight) break;
            n2 = n5;
            --n4;
            --n3;
        }
        return n2;
    }

    public static final void drawScore(Graphics graphics) {
        graphics.setColor(-16777216);
        Font font = Game.getFont(1);
        graphics.fillRect(0, 0, Game.sGameWidth, font.getHeight() + 2);
        graphics.setColor(-1);
        graphics.setFont(font);
        String string = RM.t(84);
        graphics.drawString(string + " " + sOverallScore, 1, 0, 0);
    }

    public static final void draw(Graphics graphics) {
        GameBoard.drawBackdrop(graphics);
        for (int i = 0; i < sItemsArray.length; ++i) {
            Floor floor = sItemsArray[i];
            int n = sYStartPosition - floor.getFloorIndex() * sTileSize;
            if (n + sFloorsHeight < 0 || n > Game.sGameHeight) continue;
            floor.draw(graphics, n);
        }
        GameBoard.drawWalls(graphics);
    }

    private static final void drawWalls(Graphics graphics) {
        int n = Game.sGameHeight;
        int n2 = sWallLeftImage.getHeight();
        int n3 = n / n2 + 2;
        int n4 = sWallPosOffset - n2;
        for (int i = 0; i < n3; ++i) {
            if (n4 + n2 >= 0 && n4 <= n) {
                graphics.drawImage(sWallLeftImage, 0, n4, 0);
                graphics.drawImage(sWallRightImage, Game.sGameWidth - sWallWidth, n4, 0);
            }
            n4 += n2;
        }
    }

    private static final void drawBackdrop(Graphics graphics) {
        int n = Game.sGameHeight;
        int n2 = sBackdropImage.getHeight();
        int n3 = n / n2 + 2;
        int n4 = sBackdropPosOffset - n2;
        for (int i = 0; i < n3; ++i) {
            if (n4 + n2 >= 0 && n4 <= n) {
                graphics.drawImage(sBackdropImage, sWallWidth, n4, 0);
            }
            n4 += n2;
        }
    }

    static {
        sMaxFloor = new int[2];
        sPrevFloor = null;
        sFloorWidthIdLimits = new byte[2];
    }
}

